/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.core.HttpBadRequestException;
import com.ericsson.lwac.http.core.HttpMethodNotAllowedException;
import com.ericsson.lwac.http.core.HttpNotFoundException;
import com.ericsson.lwac.http.core.HttpResponseCode;
import com.ericsson.lwac.http.xml.AbstractAdvancedXmlOperation;
import com.ericsson.lwac.http.xml.XmlOperation;
import jakarta.annotation.Resource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractDynamicXmlOperation<Rq, Rs, I extends XmlOperation<Rq, Rs>>
extends AbstractAdvancedXmlOperation {
    @Resource
    private ApplicationContext applicationContext;
    private I instance;
    private final Map<String, Method> methods = new ConcurrentHashMap<String, Method>();
    private final Map<String, HttpResponseCode> responseCodes = new ConcurrentHashMap<String, HttpResponseCode>();

    protected AbstractDynamicXmlOperation(Class<?> ifType) {
        this.inspectInterface(ifType);
    }

    public <Rms, Rmq> Rms handle(HttpOperationRequest httpOperationRequest, HttpOperationResponse httpOperationResponse, Rmq request) throws Exception {
        if (this.instance == null) {
            this.instance = (XmlOperation)this.applicationContext.getThis();
        }
        String methodName = httpOperationRequest.getHttpOperationPath().getSubPathEntry(0);
        try {
            switch (httpOperationRequest.getHttpMethod()) {
                case POST: {
                    if (methodName == null) {
                        Object response = this.instance.handle(request);
                        return (Rms)response;
                    }
                    Method method = this.methods.get(methodName);
                    if (method != null) {
                        try {
                            Object response = method.invoke(this.instance, request);
                            httpOperationResponse.setHttpResponseCode(this.responseCodes.get(methodName));
                            return (Rms)response;
                        }
                        catch (InvocationTargetException e) {
                            if (e.getTargetException() instanceof Exception) {
                                throw (Exception)e.getTargetException();
                            }
                            throw new RuntimeException(e.getTargetException());
                        }
                    }
                    throw new HttpNotFoundException("Method not supported");
                }
            }
            throw new HttpMethodNotAllowedException("HTTP method not supported");
        }
        catch (IllegalArgumentException e) {
            throw new HttpBadRequestException("Invalid request", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new HttpBadRequestException("Invalid request type", (Throwable)e);
        }
    }

    private void inspectInterface(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Must be an interface");
        }
        for (Method method : type.getMethods()) {
            DynamicMethod dynamicMethod = method.getAnnotation(DynamicMethod.class);
            if (dynamicMethod == null) continue;
            this.methods.put(method.getName(), method);
            this.responseCodes.put(method.getName(), dynamicMethod.value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DynamicMethod {
        public HttpResponseCode value() default HttpResponseCode.HTTP_OK;
    }
}

