/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.http.SessionType;
import com.ericsson.lwac.http.statistics.HttpOperationStatistics;
import com.ericsson.lwac.http.statistics.OperationContextInfo;
import com.ericsson.lwac.http.types.Context;
import com.ericsson.lwac.http.types.GetContextDetailsRequest;
import com.ericsson.lwac.http.types.GetContextDetailsResponse;
import com.ericsson.lwac.http.types.OperationName;
import com.ericsson.lwac.http.xml.AbstractXmlOperation;
import com.ericsson.lwac.http.xml.XmlOperation;
import com.ericsson.lwac.security.AccessController;
import com.ericsson.lwac.security.session.SessionContext;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Local(value={XmlOperation.class})
public class GetContextDetailsOperation
extends AbstractXmlOperation<GetContextDetailsRequest, GetContextDetailsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(GetContextDetailsOperation.class);
    private static final String CONTEXT_PREFIX = "/";
    private static final String ADMIN_ROLE = "ROLE_ADMIN";
    private static final String ROLE_ALLOWED_COMMUNICATION_CHANNELS = "ROLE_ALLOWED_COMMUNICATION_CHANNELS";
    @Resource
    private AccessController accessController;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private HttpOperationStatistics httpOperationStatistics;

    @Override
    public GetContextDetailsResponse handle(GetContextDetailsRequest request) {
        Context context = request.getContext();
        if (context == null || context.getContext() == null || context.getContext().trim().isEmpty()) {
            return this.createResponse(Collections.emptyList());
        }
        String contextName = context.getContext().trim();
        if (!this.sessionContext.hasPermission(ROLE_ALLOWED_COMMUNICATION_CHANNELS, "*") && !this.sessionContext.hasPermission(ROLE_ALLOWED_COMMUNICATION_CHANNELS, "http-" + contextName)) {
            throw new SecurityException("User does not have permission to access context: " + contextName);
        }
        List<OperationContextInfo> allOperations = this.getAllOperations();
        List<OperationName> matchingOperations = this.findMatchingOperations(contextName, allOperations);
        return this.createResponse(matchingOperations);
    }

    private List<OperationName> findMatchingOperations(String contextName, List<OperationContextInfo> allOperations) {
        if (allOperations == null || allOperations.isEmpty()) {
            logger.warn("No operations available for context matching");
            return Collections.emptyList();
        }
        return allOperations.stream().filter(operation -> this.hasMatchingContext((OperationContextInfo)operation, contextName)).map(OperationContextInfo::getClassName).filter(className -> className != null && !className.trim().isEmpty()).map(OperationName::new).collect(Collectors.toList());
    }

    private boolean hasMatchingContext(OperationContextInfo operation, String contextName) {
        return Optional.ofNullable(operation.getContexts()).orElse(Collections.emptyList()).stream().map(contextInfo -> contextInfo.getContext()).filter(Objects::nonNull).map(this::normalizeContext).anyMatch(context -> context.equals(contextName));
    }

    private String normalizeContext(String context) {
        if (context == null || context.trim().isEmpty()) {
            return "";
        }
        String trimmed = context.trim();
        return trimmed.startsWith(CONTEXT_PREFIX) && trimmed.length() > 1 ? trimmed.substring(1) : trimmed;
    }

    private GetContextDetailsResponse createResponse(List<OperationName> operationNames) {
        GetContextDetailsResponse response = new GetContextDetailsResponse();
        response.setOperationNames(operationNames);
        logger.info("Returning response with {} matching operations", (Object)operationNames.size());
        return response;
    }

    private List<OperationContextInfo> getAllOperations() {
        try {
            List httpOperations = Optional.ofNullable(this.accessController.doPrivilegedAction(() -> this.httpOperationStatistics.getAllOperations(), ADMIN_ROLE)).orElse(Collections.emptyList());
            List asyncOperations = Optional.ofNullable(this.accessController.doPrivilegedAction(() -> this.httpOperationStatistics.getAllAsyncOperations(), ADMIN_ROLE)).orElse(Collections.emptyList());
            LinkedList<OperationContextInfo> allOperations = new LinkedList<OperationContextInfo>(httpOperations);
            allOperations.addAll(asyncOperations);
            logger.debug("Retrieved {} operations from statistics service", (Object)allOperations.size());
            return allOperations;
        }
        catch (Exception e) {
            logger.error("Failed to retrieve operations from statistics service: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    @Nonnull
    public SessionType getSessionType() {
        return SessionType.REQUIRES_SESSION;
    }
}

