/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.UnexpectedErrorHandler;
import com.ericsson.lwac.http.types.ErrorResponse;
import com.ericsson.lwac.http.types.Version;
import com.ericsson.lwac.http.xml.listener.RequestResponseListenerManager;
import com.ericsson.lwac.http.xml.listener.ResponseRecord;
import jakarta.ejb.EJB;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlErrorHandler
implements UnexpectedErrorHandler {
    private static final Logger mLogger = LoggerFactory.getLogger(XmlErrorHandler.class.getPackage().getName());
    private JAXBContext mContext;
    @EJB
    private RequestResponseListenerManager requestResponseListenerManager;

    @Override
    public void handle(RequestCorrelationId correlationId, String operation, Version version, OutputStream responseOutputStream, Exception e) throws IOException {
        try {
            ErrorResponse errorResponse = this.getErrorResponse(operation, version, e);
            this.requestResponseListenerManager.publish(new ResponseRecord(correlationId, errorResponse));
            if (this.mContext == null) {
                this.mContext = JAXBContext.newInstance(ErrorResponse.class);
            }
            this.mContext.createMarshaller().marshal((Object)errorResponse, responseOutputStream);
            responseOutputStream.flush();
        }
        catch (JAXBException e1) {
            mLogger.error("Marshalling error", e);
        }
    }

    public abstract ErrorResponse getErrorResponse(String var1, Version var2, Exception var3);

    @Override
    public String getContentType() {
        return "text/xml";
    }
}

