/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.http.HttpAuthenticationManager;
import com.ericsson.lwac.http.types.ChangePasswordRequest;
import com.ericsson.lwac.http.types.LoginRequest;
import com.ericsson.lwac.http.types.SecondaryLoginRequest;
import com.ericsson.lwac.http.xml.JAXBContextRepository;
import com.ericsson.lwac.security.authentication.AuthenticationErrorException;
import com.ericsson.lwac.security.authentication.ComplexSecret;
import com.ericsson.lwac.security.authentication.Secret;
import com.ericsson.lwac.security.authentication.StringSecret;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Local(value={HttpAuthenticationManager.class})
@Singleton
public class XmlLoginOperation
implements HttpAuthenticationManager {
    private static final Logger logger = LoggerFactory.getLogger(XmlLoginOperation.class);
    private JAXBContext context;

    public XmlLoginOperation() {
        try {
            this.context = JAXBContext.newInstance(LoginRequest.class, ChangePasswordRequest.class, SecondaryLoginRequest.class);
        }
        catch (JAXBException e) {
            logger.error("Error loading jaxb context", e);
        }
    }

    @Override
    public HttpAuthenticationManager.PrimaryLoginInformation primaryLogin(HttpServletRequest httpServletRequest) throws IOException, AuthenticationErrorException {
        try {
            Unmarshaller unm = this.context.createUnmarshaller();
            Source xmlSource = JAXBContextRepository.createXmlSource(httpServletRequest.getInputStream());
            final LoginRequest request = (LoginRequest)unm.unmarshal(xmlSource);
            return new HttpAuthenticationManager.PrimaryLoginInformation(){

                @Override
                public String getUserId() {
                    return request.getIdentity();
                }

                @Override
                public Secret getCredential() {
                    return new ComplexSecret(request.getCredential().getSecret(), request.getCredential().getType());
                }
            };
        }
        catch (JAXBException e) {
            throw new AuthenticationErrorException();
        }
    }

    @Override
    public HttpAuthenticationManager.ChangePasswordInformation changePassword(HttpServletRequest httpServletRequest) throws IOException, AuthenticationErrorException {
        try {
            Unmarshaller unm = this.context.createUnmarshaller();
            Source xmlSource = JAXBContextRepository.createXmlSource(httpServletRequest.getInputStream());
            final ChangePasswordRequest request = (ChangePasswordRequest)unm.unmarshal(xmlSource);
            return new HttpAuthenticationManager.ChangePasswordInformation(){

                @Override
                public String getIdentity() {
                    return request.getIdentity();
                }

                @Override
                public Secret getCredential() {
                    if (request.getCredential() == null || request.getCredential().getSecret() == null) {
                        return null;
                    }
                    return new StringSecret(request.getCredential().getSecret());
                }

                @Override
                public Secret getNewCredential() {
                    if (request.getNewCredential() == null || request.getNewCredential().getSecret() == null) {
                        return null;
                    }
                    return new StringSecret(request.getNewCredential().getSecret());
                }

                @Override
                public Secret getNewCredentialRepeated() {
                    if (request.getNewCredentialRepeated() == null || request.getNewCredentialRepeated().getSecret() == null) {
                        return null;
                    }
                    return new StringSecret(request.getNewCredentialRepeated().getSecret());
                }
            };
        }
        catch (JAXBException e) {
            throw new AuthenticationErrorException();
        }
    }

    @Override
    public HttpAuthenticationManager.SecondaryLoginInformation secondaryLogin(HttpServletRequest httpServletRequest) throws IOException, AuthenticationErrorException {
        try {
            Unmarshaller unm = this.context.createUnmarshaller();
            Source xmlSource = JAXBContextRepository.createXmlSource(httpServletRequest.getInputStream());
            final SecondaryLoginRequest request = (SecondaryLoginRequest)unm.unmarshal(xmlSource);
            return new HttpAuthenticationManager.SecondaryLoginInformation(){

                @Override
                public Secret getCredential() {
                    return new StringSecret(request.getCredential().getSecret());
                }

                @Override
                public String getAuthType() {
                    return request.getCredential().getType();
                }
            };
        }
        catch (JAXBException e) {
            throw new AuthenticationErrorException();
        }
    }
}

