/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.http.VersionResolver;
import com.ericsson.lwac.http.core.HttpBadRequestException;
import com.ericsson.lwac.http.types.Version;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.mimepull.MIMEMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(serviceInterface=VersionResolver.class)
public class XmlNamespaceVersionResolver
implements VersionResolver {
    private static final Logger logger = LoggerFactory.getLogger(XmlNamespaceVersionResolver.class);
    private static final Pattern namespacePrefixPattern = Pattern.compile("^(<\\?xml\\s+version\\s*=\\s*\"1\\.0\"\\s+encoding\\s*=\\s*\"[A-Za-z][A-Za-z0-9._-]*\"\\s*(?:\\s+standalone\\s*=\\s*\"(no|yes)\")?\\s*\\?>)?\\s*<\\s*(\\w+?):", 32);
    private final Pattern boundaryPattern = Pattern.compile("boundary=([\\w_\\-\\s<>.:,=+?'()\\/]+);?");
    private static final int VERSION_LOOKAHEAD_LENGTH = 8192;
    private static final int NAMESPACE_PREFIX_GROUP_INDEX = 3;
    private static final int NAMESPACE_VERSION_GROUP_INDEX = 1;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Version resolve(HttpServletRequest request) throws HttpBadRequestException {
        Version version = Version.DEFAULT_VERSION;
        try {
            byte[] buffer;
            void var3_6;
            int len;
            Object var3_3 = null;
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("multipart/")) {
                Matcher matcher = this.boundaryPattern.matcher(contentType);
                if (!matcher.find()) throw new HttpBadRequestException("Could not parse version: " + contentType);
                MIMEMessage message = new MIMEMessage((InputStream)request.getInputStream(), matcher.group(1));
                InputStream inputStream = message.getPart(0).read();
            } else {
                ServletInputStream servletInputStream = request.getInputStream();
            }
            if ((len = var3_6.read(buffer = new byte[8192], 0, 8192)) <= 0) return version;
            String input = new String(buffer, 0, len);
            Matcher matcher = namespacePrefixPattern.matcher(input);
            if (matcher.find()) {
                String prefix = matcher.group(3);
                Pattern pattern = Pattern.compile(" xmlns:" + prefix + "=\"[^\"]+/v([0-9]+_[0-9]+)", 32);
                return this.findVersion(pattern.matcher(input));
            }
            Pattern pattern = Pattern.compile(" xmlns=\"[^\"]+/v([0-9]+_[0-9]+)", 32);
            return this.findVersion(pattern.matcher(input));
        }
        catch (IOException iOException) {
            logger.error("Could not extract version from xml request.", iOException);
            return version;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpBadRequestException("Could not parse version", (Throwable)illegalArgumentException);
        }
    }

    private Version findVersion(Matcher versionMatcher) {
        Version version = Version.DEFAULT_VERSION;
        if (versionMatcher.find()) {
            version = new Version(versionMatcher.group(1).replace('_', '.'));
        }
        return version;
    }
}

