/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.messagebus;

import com.ericsson.lwac.ValidationException;
import com.google.common.base.Objects;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

public class MessageConsumerConfig {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private final String groupId;
    @NotNull
    private final Duration maxTimeBetweenPolls;

    public MessageConsumerConfig(Builder builder) {
        this.groupId = builder.groupId;
        this.maxTimeBetweenPolls = builder.maxTimeBetweenPolls;
    }

    Optional<String> getGroupId() {
        return Optional.ofNullable(this.groupId);
    }

    Duration getMaxTimeBetweenPolls() {
        return this.maxTimeBetweenPolls;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hashCode(this.groupId, this.maxTimeBetweenPolls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageConsumerConfig)) {
            return false;
        }
        MessageConsumerConfig that = (MessageConsumerConfig)o;
        return Objects.equal(this.groupId, that.groupId) && Objects.equal(this.maxTimeBetweenPolls, that.maxTimeBetweenPolls);
    }

    public String toString() {
        return "MessageConsumerConfig{groupId='" + this.groupId + "', maxTimeBetweenPolls=" + String.valueOf(this.maxTimeBetweenPolls) + "}";
    }

    public static class Builder {
        private String groupId;
        private Duration maxTimeBetweenPolls;

        public Builder() {
        }

        public Builder(MessageConsumerConfig config) {
            this.groupId = config.groupId;
            this.maxTimeBetweenPolls = config.maxTimeBetweenPolls;
        }

        public Builder groupId(String id) {
            if (id != null && !id.isEmpty()) {
                this.groupId = id;
            }
            return this;
        }

        public Builder maxTimeBetweenPolls(Duration maxTimeBetweenPolls) {
            if (maxTimeBetweenPolls != null) {
                this.maxTimeBetweenPolls = maxTimeBetweenPolls;
            }
            return this;
        }

        public MessageConsumerConfig build() {
            MessageConsumerConfig config = new MessageConsumerConfig(this);
            Set<ConstraintViolation<MessageConsumerConfig>> violations = VALIDATOR.validate(config, new Class[0]);
            if (!violations.isEmpty()) {
                ConstraintViolation<MessageConsumerConfig> violation = violations.iterator().next();
                throw new ValidationException(String.format("Field '%s' %s.", violation.getPropertyPath(), violation.getMessage()));
            }
            if (this.maxTimeBetweenPolls.isNegative() || this.maxTimeBetweenPolls.isZero()) {
                throw new ValidationException("Field 'maxTimeBetweenPolls' must be positive.");
            }
            return config;
        }
    }
}

