/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.monitoring;

import jakarta.validation.constraints.PositiveOrZero;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CounterIncrement
implements Serializable,
Comparable<CounterIncrement> {
    public static final CounterIncrement ONE = new CounterIncrement(1);
    @PositiveOrZero
    private final int value;

    private CounterIncrement(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public CounterIncrement plus(CounterIncrement other) {
        return new CounterIncrement(this.value + other.value);
    }

    @Override
    public int compareTo(CounterIncrement other) {
        return Integer.compare(this.value, other.value);
    }

    public static CounterIncrement fromInteger(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("CounterIncrement value must be zero or greater");
        }
        if (value == 1) {
            return ONE;
        }
        return new CounterIncrement(value);
    }

    public static CounterIncrement one() {
        return ONE;
    }

    public static CounterIncrement plus(CounterIncrement left, CounterIncrement right) {
        return left.plus(right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterIncrement that = (CounterIncrement)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

