/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.monitoring.health;

import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class Health
implements Serializable,
Iterable<Health> {
    private static final long serialVersionUID = 1L;
    public static final Status UNKNOWN = Status.UNKNOWN;
    public static final Status UP = Status.UP;
    public static final Status DOWN = Status.DOWN;
    private final Status status;
    private final String errorCode;
    private final String message;
    private final Duration latency;
    private final List<Health> subHealth;

    protected Health(Builder builder) {
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
        this.latency = builder.latency;
        this.subHealth = new LinkedList<Health>(builder.subHealth);
    }

    public Optional<Status> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<String> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Duration getLatency() {
        return this.latency;
    }

    public List<? extends Health> getSubHealth() {
        return this.subHealth;
    }

    @Override
    public Iterator<Health> iterator() {
        return this.subHealth.iterator();
    }

    public static Health up() {
        return Health.builder().status(Status.UP).build();
    }

    public static Health down() {
        return Health.builder().status(Status.DOWN).build();
    }

    public static Health down(String errorCode) {
        return Health.builder().status(Status.DOWN).errorCode(errorCode).build();
    }

    public static Health unknown() {
        return Health.builder().status(Status.UNKNOWN).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Status status;
        private String errorCode;
        private String message;
        private Duration latency = Duration.ofSeconds(0L);
        private final List<Health> subHealth = new LinkedList<Health>();

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder latency(Duration latency) {
            this.latency = latency;
            return this;
        }

        public Builder message(String message, Object ... args) {
            this.message = message != null ? String.format(message, args) : null;
            return this;
        }

        public Builder health(Health health) {
            if (health != null) {
                this.subHealth.add(health);
            }
            return this;
        }

        public Health build() {
            return new Health(this);
        }
    }

    public static enum Status {
        UNKNOWN,
        UP,
        DOWN,
        ERROR;

    }
}

