/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.monitoring.health;

import java.io.Serializable;

public class HealthProviderDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean livenessProbeIndication;
    private final Severity severity;

    private HealthProviderDetails(Builder builder) {
        this.livenessProbeIndication = builder.livenessProbeIndication;
        this.severity = builder.severity;
    }

    public boolean isLivenessProbeIndication() {
        return this.livenessProbeIndication;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isMatching(HealthProviderDetails other) {
        return this.severity.equals((Object)other.severity) && this.livenessProbeIndication == other.isLivenessProbeIndication();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean livenessProbeIndication = false;
        private Severity severity;

        public Builder withLivenessProbeIndication(boolean livenessProbeIndication) {
            this.livenessProbeIndication = livenessProbeIndication;
            return this;
        }

        public Builder withSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public HealthProviderDetails build() {
            return new HealthProviderDetails(this);
        }
    }

    public static enum Severity {
        LOW,
        HIGH;

    }
}

