/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.net.http.core.HttpHeader;
import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;

public class HttpClientConfiguration {
    private final String name;
    private final SSLContext sslContext;
    private final Set<String> sslCiphers;
    private final Set<String> sslProtocols;
    private final int maxConnections;
    private final Integer maxConnectionsPerHost;
    private final Integer maxRequestRetry;
    private final Duration acquireConnectionTimeout;
    private final Duration requestTimeout;
    private final Duration maximumConnectionKeepAliveTime;
    private final Duration idleTime;
    private final Duration idleTimeCheckInterval;
    private final Duration connectionTimeout;
    private final boolean ignoreCookies;
    private final boolean sendDateHeader;
    private final HttpHeaders headers;

    private HttpClientConfiguration(Builder builder) {
        this.name = builder.name;
        this.sslContext = builder.sslContext;
        this.sslCiphers = builder.sslCiphers;
        this.sslProtocols = builder.sslProtocols;
        this.maxConnections = builder.maxConnections;
        this.maxConnectionsPerHost = builder.maxConnectionsPerHost;
        this.maxRequestRetry = builder.maxRequestRetry;
        this.acquireConnectionTimeout = builder.acquireConnectionTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.maximumConnectionKeepAliveTime = builder.maximumConnectionKeepAliveTime;
        this.idleTime = builder.idleTime;
        this.idleTimeCheckInterval = builder.idleTimeCheckInterval;
        this.connectionTimeout = builder.connectionTimeout;
        this.ignoreCookies = builder.ignoreCookies;
        this.sendDateHeader = builder.sendDateHeader;
        this.headers = builder.headers.build();
    }

    public String getName() {
        return this.name;
    }

    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    public Optional<Set<String>> getSslCiphers() {
        return Optional.ofNullable(this.sslCiphers).filter(Predicate.not(Set::isEmpty));
    }

    public Optional<Set<String>> getSslProtocols() {
        return Optional.ofNullable(this.sslProtocols).filter(Predicate.not(Set::isEmpty));
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public Optional<Integer> getMaxConnectionsPerHost() {
        return Optional.ofNullable(this.maxConnectionsPerHost);
    }

    public Optional<Duration> getAcquireConnectionTimeout() {
        return Optional.ofNullable(this.acquireConnectionTimeout);
    }

    public Optional<Integer> getMaxRequestRetry() {
        return Optional.ofNullable(this.maxRequestRetry);
    }

    public Optional<Duration> getRequestTimeout() {
        return Optional.ofNullable(this.requestTimeout);
    }

    public Optional<Duration> getMaximumConnectionKeepAliveTime() {
        return Optional.ofNullable(this.maximumConnectionKeepAliveTime);
    }

    public Optional<Duration> getIdleTime() {
        return Optional.ofNullable(this.idleTime);
    }

    public Optional<Duration> getIdleTimeCheckInterval() {
        return Optional.ofNullable(this.idleTimeCheckInterval);
    }

    public Optional<Duration> getConnectionTimeout() {
        return Optional.ofNullable(this.connectionTimeout);
    }

    public boolean isIgnoreCookies() {
        return this.ignoreCookies;
    }

    public boolean isSendDateHeader() {
        return this.sendDateHeader;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private SSLContext sslContext;
        private Set<String> sslCiphers;
        private Set<String> sslProtocols;
        private int maxConnections = 200;
        private Integer maxConnectionsPerHost;
        private Integer maxRequestRetry;
        private Duration acquireConnectionTimeout;
        private Duration requestTimeout = Duration.ofSeconds(10L);
        private Duration maximumConnectionKeepAliveTime;
        private Duration idleTime = Duration.ofSeconds(30L);
        private Duration idleTimeCheckInterval = Duration.ofSeconds(30L);
        private Duration connectionTimeout = Duration.ofSeconds(10L);
        private boolean ignoreCookies = false;
        private boolean sendDateHeader = false;
        private final HttpHeaders.Builder headers = HttpHeaders.newBuilder();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder sslCiphers(Set<String> sslCiphers) {
            this.sslCiphers = sslCiphers;
            return this;
        }

        public Builder sslProtocols(Set<String> sslProtocols) {
            this.sslProtocols = sslProtocols;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxConnectionsPerHost(Integer maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder maxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder acquireConnectionTimeout(int acquireConnectionTimeout, TimeUnit acquireConnectionTimeoutTimeUnit) {
            if (acquireConnectionTimeout > 0) {
                Preconditions.checkNotNull(acquireConnectionTimeoutTimeUnit, "'acquireConnectionTimeoutTimeUnit' is invalid, can not be null");
                this.acquireConnectionTimeout = Duration.of(acquireConnectionTimeout, acquireConnectionTimeoutTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder requestTimeout(int requestTimeout, TimeUnit requestTimeoutTimeUnit) {
            if (requestTimeout > 0) {
                Preconditions.checkNotNull(requestTimeoutTimeUnit, "'requestTimeoutTimeUnit' is invalid, can not be null");
                this.requestTimeout = Duration.of(requestTimeout, requestTimeoutTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder maximumConnectionKeepAliveTime(int maximumConnectionKeepAliveTime, TimeUnit maximumConnectionKeepAliveTimeUnit) {
            if (maximumConnectionKeepAliveTime > 0) {
                Preconditions.checkNotNull(maximumConnectionKeepAliveTimeUnit, "'maximumConnectionKeepAliveTimeUnit' is invalid, can not be null");
                this.maximumConnectionKeepAliveTime = Duration.of(maximumConnectionKeepAliveTime, maximumConnectionKeepAliveTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder idleTime(int idleTime, TimeUnit idleTimeUnit) {
            if (idleTime > 0) {
                Preconditions.checkNotNull(idleTimeUnit, "'idleTimeUnit' is invalid, can not be null");
                this.idleTime = Duration.of(idleTime, idleTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder idleTimeCheckInterval(int idleTimeCheckInterval, TimeUnit idleTimeCheckIntervalTimeUnit) {
            if (idleTimeCheckInterval > 0) {
                Preconditions.checkNotNull(idleTimeCheckIntervalTimeUnit, "'idleTimeCheckIntervalTimeUnit' is invalid, can not be null");
                this.idleTimeCheckInterval = Duration.of(idleTimeCheckInterval, idleTimeCheckIntervalTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout, TimeUnit connectionTimeoutTimeUnit) {
            if (connectionTimeout > 0) {
                Preconditions.checkNotNull(connectionTimeoutTimeUnit, "'connectionTimeoutTimeUnit' is invalid, can not be null");
                this.connectionTimeout = Duration.of(connectionTimeout, connectionTimeoutTimeUnit.toChronoUnit());
            }
            return this;
        }

        public Builder ignoreCookies(boolean ignoreCookies) {
            this.ignoreCookies = ignoreCookies;
            return this;
        }

        public Builder sendDateHeader(boolean sendDateHeader) {
            this.sendDateHeader = sendDateHeader;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.header(HttpHeader.fromNameAndValue(name, value));
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.headers(headers.entrySet().stream().map(entry -> HttpHeader.fromNameAndValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this);
        }
    }
}

