/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.net.http.core.HttpHeader;
import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.ericsson.lwac.net.http.core.HttpMethod;
import com.ericsson.lwac.net.http.core.HttpQueryParameter;
import com.ericsson.lwac.net.http.core.HttpQueryParameters;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private static final Charset AUTHORIZATION_CHARSET = StandardCharsets.ISO_8859_1;
    private final HttpMethod method;
    private final String body;
    private final URL url;
    private final Map<String, String> headers;
    private final HttpQueryParameters queryParameters;

    protected HttpRequest(Builder<? extends Builder> builder) {
        this.method = builder.method;
        this.body = builder.body;
        String baseUrl = this.addEndingSlash(builder.baseUrl);
        String path = this.removeStartingSlash(builder.path);
        String fullUrl = baseUrl + path;
        try {
            this.url = new URI(fullUrl).normalize().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Couldn't build URL of " + fullUrl, e);
        }
        if (!Strings.isNullOrEmpty(builder.username) && !Strings.isNullOrEmpty(builder.password)) {
            builder.headers.put("Authorization", this.createEncodedBasicAuthorization(builder.username, builder.password));
        }
        this.headers = builder.headers;
        this.queryParameters = builder.queryParameters.build();
    }

    private String removeStartingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private String addEndingSlash(String url) {
        return url + (url.endsWith("/") ? "" : "/");
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders.Builder builder = HttpHeaders.newBuilder();
        this.headers.forEach(builder::header);
        return builder.build();
    }

    public void setHeader(HttpHeader header) {
        Preconditions.checkNotNull(header, "'header' is invalid, can not be null");
        this.headers.put(header.getName(), header.getValue());
    }

    public HttpQueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private String createEncodedBasicAuthorization(String username, String password) {
        String plaintextAuth = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(plaintextAuth.getBytes(AUTHORIZATION_CHARSET));
    }

    public static class Builder<T extends Builder> {
        private HttpMethod method;
        private String body;
        private String path;
        private String baseUrl;
        private final Map<String, String> headers = new HashMap<String, String>();
        private HttpQueryParameters.Builder queryParameters = HttpQueryParameters.newBuilder();
        private String username;
        private String password;

        protected Builder() {
        }

        public T method(HttpMethod val) {
            this.method = val;
            return (T)this;
        }

        public T body(String val) {
            this.body = val;
            return (T)this;
        }

        public T baseUrl(String val) {
            this.baseUrl = val;
            return (T)this;
        }

        public T path(String val) {
            this.path = val;
            return (T)this;
        }

        public T header(String key, String val) {
            this.headers.put(key, val);
            return (T)this;
        }

        public T header(HttpHeader httpHeader) {
            this.headers.put(httpHeader.getName(), httpHeader.getValue());
            return (T)this;
        }

        public T headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return (T)this;
        }

        public T headers(HttpHeaders headers) {
            headers.forEach(this::header);
            return (T)this;
        }

        public T queryParameter(HttpQueryParameter queryParameter) {
            this.queryParameters.parameter(queryParameter);
            return (T)this;
        }

        public T queryParameters(HttpQueryParameters queryParameters) {
            this.queryParameters.parameters(queryParameters);
            return (T)this;
        }

        public T username(String username) {
            this.username = username;
            return (T)this;
        }

        public T password(String password) {
            this.password = password;
            return (T)this;
        }

        public HttpRequest build() {
            Preconditions.checkNotNull(this.baseUrl, "'baseUrl' is invalid, can not be null");
            Preconditions.checkNotNull(this.path, "'path' is invalid, can not be null");
            return new HttpRequest(this);
        }
    }
}

