/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.core;

import com.google.common.base.Preconditions;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public class HttpHeader {
    public static final String X_SIGNATURE = "X-Signature";
    public static final String X_LWAC_EXECUTE_AS = "X-lwac-execute-as";
    public static final String X_LWAC_LOCATION_DATA = "X-lwac-location-data";
    public static final String X_LWAC_ADDITIONAL_RATING = "X-lwac-additional-rating";
    public static final String X_LWAC_IMSI = "X-lwac-imsi";
    public static final String X_LWAC_OTP_CHANNEL = "X-lwac-otp-channel";
    public static final String X_LWAC_INSTRUMENT_PROVIDER_DATA = "X-lwac-instrument-provider-data";
    public static final String X_LWAC_INSTRUMENT_PROVIDER_DATA_SENDER = "x-lwac-instrument-provider-data-sender";
    public static final String X_LWAC_INSTRUMENT_PROVIDER_DATA_RECEIVER = "x-lwac-instrument-provider-data-receiver";
    @NotNull
    private final String name;
    @NotNull
    private final String value;

    private HttpHeader(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    private HttpHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static HttpHeader fromNameAndValue(String name, String value) {
        Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
        if (value == null) {
            return null;
        }
        return new HttpHeader(name, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHeader other = (HttpHeader)obj;
        if (this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public HttpHeader build() {
            if (this.value == null) {
                return null;
            }
            Preconditions.checkNotNull(this.name, "'name' is invalid, can not be null");
            return new HttpHeader(this);
        }
    }
}

