/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.ws.core;

import java.util.Objects;

public final class WebSocketCloseCode {
    public static final WebSocketCloseCode NORMAL = new WebSocketCloseCode(1000, "Normal closure");
    public static final WebSocketCloseCode GOING_AWAY = new WebSocketCloseCode(1001, "Endpoint is going away");
    public static final WebSocketCloseCode PROTOCOL_ERROR = new WebSocketCloseCode(1002, "Protocol error");
    public static final WebSocketCloseCode CANNOT_ACCEPT = new WebSocketCloseCode(1003, "Received data cannot be accepted (invalid format)");
    public static final WebSocketCloseCode RESERVED = new WebSocketCloseCode(1004, "Reserved for future use");
    public static final WebSocketCloseCode NO_STATUS_RECEIVED = new WebSocketCloseCode(1005, "No status code was present");
    public static final WebSocketCloseCode ABNORMAL = new WebSocketCloseCode(1006, "Connection closed abnormally");
    public static final WebSocketCloseCode INVALID_DATA = new WebSocketCloseCode(1007, "Message contains inconsistent data");
    public static final WebSocketCloseCode POLICY_VIOLATION = new WebSocketCloseCode(1008, "Message violates policy");
    public static final WebSocketCloseCode TOO_BIG = new WebSocketCloseCode(1009, "Message too big to process");
    public static final WebSocketCloseCode MANDATORY_EXTENSION = new WebSocketCloseCode(1010, "Server failed to negotiate required extensions");
    public static final WebSocketCloseCode SERVER_ERROR = new WebSocketCloseCode(1011, "Server encountered unexpected condition");
    public static final WebSocketCloseCode TLS_HANDSHAKE_FAIL = new WebSocketCloseCode(1015, "TLS handshake failure");
    private final int code;
    private final String description;

    private WebSocketCloseCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static WebSocketCloseCode fromCode(int code) {
        switch (code) {
            case 1000: {
                return NORMAL;
            }
            case 1001: {
                return GOING_AWAY;
            }
            case 1002: {
                return PROTOCOL_ERROR;
            }
            case 1003: {
                return CANNOT_ACCEPT;
            }
            case 1004: {
                return RESERVED;
            }
            case 1005: {
                return NO_STATUS_RECEIVED;
            }
            case 1006: {
                return ABNORMAL;
            }
            case 1007: {
                return INVALID_DATA;
            }
            case 1008: {
                return POLICY_VIOLATION;
            }
            case 1009: {
                return TOO_BIG;
            }
            case 1010: {
                return MANDATORY_EXTENSION;
            }
            case 1011: {
                return SERVER_ERROR;
            }
            case 1015: {
                return TLS_HANDSHAKE_FAIL;
            }
        }
        return new WebSocketCloseCode(code, "Closing");
    }

    public String toString() {
        return String.valueOf(this.code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketCloseCode that = (WebSocketCloseCode)o;
        return this.code == that.code;
    }

    public int hashCode() {
        return Objects.hashCode(this.code);
    }
}

