/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.ws.core;

import com.ericsson.lwac.net.http.core.HttpHeader;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class WebSocketSubProtocol {
    private static final String EWP_XML_PREFIX = "ewp-xml";
    private static final Pattern VERSION = Pattern.compile("^.+-v(\\d+)\\.(\\d+)$");
    public static final WebSocketSubProtocol NONE = new WebSocketSubProtocol();
    public static final WebSocketSubProtocol EWP_XML = new WebSocketSubProtocol("ewp-xml");
    private final String value;

    private WebSocketSubProtocol() {
        this.value = null;
    }

    private WebSocketSubProtocol(String value) {
        this.value = value;
    }

    public Optional<HttpHeader> toHttpHeader() {
        return Optional.ofNullable(this.value).map(subProtocol -> HttpHeader.fromNameAndValue("Sec-WebSocket-Protocol", subProtocol));
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.value).map(VERSION::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1) + "." + matcher.group(2));
    }

    public boolean isEwpXmlDerivative() {
        return Optional.ofNullable(this.value).map(subProtocol -> subProtocol.startsWith(EWP_XML_PREFIX)).orElse(false);
    }

    public WebSocketSubProtocol withVersion(String version) {
        Preconditions.checkNotNull(version, "'version' is invalid, can not be null");
        if (this.value == null) {
            throw new IllegalArgumentException("Unable to version the empty sub-protocol");
        }
        if (VERSION.matcher(this.value).matches()) {
            throw new IllegalArgumentException("Unable to add version to sub protocol with existing version");
        }
        String versionedValue = this.value + "-v" + version;
        if (!VERSION.matcher(versionedValue).matches()) {
            throw new IllegalArgumentException("Version did not match the pattern of <major>.<minor>");
        }
        return WebSocketSubProtocol.fromString(versionedValue);
    }

    public String getValueAsString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketSubProtocol that = (WebSocketSubProtocol)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public static WebSocketSubProtocol ewpXmlWithSuffix(String suffix) {
        Preconditions.checkNotNull(suffix, "'name' is invalid, can not be null");
        return WebSocketSubProtocol.fromString(WebSocketSubProtocol.EWP_XML.value + "." + suffix);
    }

    public static WebSocketSubProtocol fromString(String value) {
        if (value == null) {
            return NONE;
        }
        if (WebSocketSubProtocol.EWP_XML.value.equals(value.trim())) {
            return EWP_XML;
        }
        return new WebSocketSubProtocol(value.trim());
    }
}

