/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, Permission> subPermissions;

    public Permission(String name) {
        this.name = name;
        this.subPermissions = Collections.emptyMap();
    }

    public Permission(String name, Set<Permission> subPermissions) {
        this.name = name;
        this.subPermissions = Permission.mapFromSet(subPermissions);
    }

    private static Map<String, Permission> mapFromSet(Set<Permission> permissions) {
        HashMap<String, Permission> map = new HashMap<String, Permission>();
        for (Permission p : permissions) {
            map.put(p.getName(), p);
        }
        return Collections.unmodifiableMap(map);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSubPermissions() {
        return !this.subPermissions.isEmpty();
    }

    public Collection<Permission> getSubPermissions() {
        return this.subPermissions.values();
    }

    public Permission getSubPermission(Permission permission) {
        return permission == null ? null : this.subPermissions.get(permission.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Permission [name=" + this.name + "]";
    }
}

