/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authentication;

import com.ericsson.lwac.security.authentication.AuthenticationErrorException;
import com.ericsson.lwac.security.authentication.AuthenticationFailedException;
import com.ericsson.lwac.security.authentication.AuthenticationProviderResult;
import com.ericsson.lwac.security.authentication.ChangeCredentialException;
import com.ericsson.lwac.security.authentication.InvalidCredentialException;
import com.ericsson.lwac.security.authentication.Secret;
import java.util.Optional;

public interface AuthenticationProvider {
    public AuthenticationProviderResult authenticatePrimary(String var1, String var2, Secret var3) throws AuthenticationErrorException, AuthenticationFailedException;

    public AuthenticationProviderResult authenticateSecondary(String var1, Secret var2) throws AuthenticationErrorException, AuthenticationFailedException;

    default public AuthenticationProviderResult authenticateSecondary(String sessionId, Secret secret, String secretType) throws AuthenticationErrorException, AuthenticationFailedException {
        throw new UnsupportedOperationException("TOTP authentication not supported by authentication provider");
    }

    public void changeCredential(String var1, String var2, Secret var3, Secret var4, Secret var5) throws ChangeCredentialException, AuthenticationErrorException, AuthenticationFailedException, InvalidCredentialException;

    public boolean requireSessionForChangingCredential();

    default public boolean isSupportedSecret(Secret secret) {
        return true;
    }

    default public AuthenticationProviderResult verifyUnauthenticatedSession(String sessionToken) throws AuthenticationFailedException {
        throw new AuthenticationFailedException();
    }

    default public boolean onResumeSession(String sessionId, String userid) {
        return true;
    }

    default public Optional<Integer> getAllowedNumberOfTokens(String userId) {
        return Optional.empty();
    }

    default public boolean isTotpSupportEnabled() {
        return false;
    }
}

