/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authentication;

import com.ericsson.lwac.security.AuthenticationStatus;
import com.ericsson.lwac.security.Permission;
import com.ericsson.lwac.security.authentication.PermissionKey;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class AuthenticationProviderResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AuthenticationStatus status;
    private final String userId;
    private final String userIdType;
    private final String challenge;
    private final String uniqueId;
    private final int allowedSessions;
    private final Integer allowedTokens;
    private final SessionRejectionPolicy policy;
    private final Set<Permission> permissions;
    private final LocalDateTime sessionEndTime;
    private final PermissionKey permissionsKey;
    private final long idTokenExpiryAt;

    private AuthenticationProviderResult(Builder builder) {
        this.status = builder.status;
        this.userId = builder.userId;
        this.userIdType = builder.userIdType;
        this.challenge = builder.challenge;
        this.uniqueId = builder.uniqueId;
        this.policy = builder.policy;
        this.permissions = builder.permissions;
        this.allowedSessions = builder.allowedSessions;
        this.allowedTokens = builder.allowedTokens;
        this.sessionEndTime = builder.sessionEndTime;
        this.permissionsKey = builder.permissionsKey;
        this.idTokenExpiryAt = builder.idTokenExpiryAt;
    }

    public AuthenticationStatus getStatus() {
        return this.status;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getAllowedSessions() {
        return this.allowedSessions;
    }

    public Optional<Integer> getAllowedTokens() {
        return Optional.ofNullable(this.allowedTokens);
    }

    public SessionRejectionPolicy getPolicy() {
        return this.policy;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public Optional<LocalDateTime> getSessionEndTime() {
        return Optional.ofNullable(this.sessionEndTime);
    }

    public PermissionKey getPermissionsKey() {
        return this.permissionsKey;
    }

    public long getIdTokenExpiryAt() {
        return this.idTokenExpiryAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationStatus status;
        private String userId;
        private String userIdType;
        private String challenge;
        private String uniqueId;
        private SessionRejectionPolicy policy;
        private int allowedSessions;
        private Integer allowedTokens;
        private final Set<Permission> permissions = new HashSet<Permission>();
        private LocalDateTime sessionEndTime;
        private PermissionKey permissionsKey;
        private long idTokenExpiryAt;

        public Builder authenticationStatus(AuthenticationStatus val) {
            this.status = val;
            return this;
        }

        public Builder challenge(String val) {
            this.challenge = val;
            return this;
        }

        public Builder identity(String val1, String val2) {
            this.userId = val1;
            this.userIdType = val2;
            return this;
        }

        public Builder uniqueId(String val) {
            this.uniqueId = val;
            return this;
        }

        public Builder allowedSessions(int nAllowedSessions) {
            this.allowedSessions = nAllowedSessions;
            return this;
        }

        public Builder allowedTokens(int val) {
            this.allowedTokens = val;
            return this;
        }

        public Builder policy(SessionRejectionPolicy val) {
            this.policy = val;
            return this;
        }

        public Builder permissions(Permission ... val) {
            this.permissions.addAll(Arrays.asList(val));
            return this;
        }

        public Builder permissions(String ... val) {
            for (String permission : val) {
                this.permissions.add(new Permission(permission));
            }
            return this;
        }

        public Builder permissions(Collection<Permission> val) {
            this.permissions.addAll(val);
            return this;
        }

        public Builder sessionEndTime(LocalDateTime val) {
            this.sessionEndTime = val;
            return this;
        }

        public Builder permissionsKey(PermissionKey val) {
            this.permissionsKey = val;
            return this;
        }

        public Builder idTokenExpiryAt(long val) {
            this.idTokenExpiryAt = val;
            return this;
        }

        public AuthenticationProviderResult create() {
            if (this.status == null) {
                throw new IllegalArgumentException("Missing status");
            }
            if (this.userIdType == null || this.userId == null) {
                throw new IllegalArgumentException("Missing identity");
            }
            if (this.status == AuthenticationStatus.CHALLENGE_REQUIRED && this.challenge == null) {
                throw new IllegalArgumentException("Challenge requried but is null");
            }
            if (this.uniqueId != null && (this.allowedSessions < 1 || this.policy == null)) {
                throw new IllegalArgumentException("uniqueId set but not allowedSessions or policy");
            }
            return new AuthenticationProviderResult(this);
        }
    }

    public static enum SessionRejectionPolicy {
        REPLACE_OLDEST,
        DENY_NEW_SESSION;

    }
}

