/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authorization;

import com.ericsson.lwac.security.Permission;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AuthorizationProviderResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String userIdType;
    private final Set<Permission> permissions = new HashSet<Permission>();

    AuthorizationProviderResult() {
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public static class Builder {
        private final AuthorizationProviderResult result = new AuthorizationProviderResult();

        public Builder identity(String userId, String userIdType) {
            this.result.userId = userId;
            this.result.userIdType = userIdType;
            return this;
        }

        public Builder permissions(Permission ... permissions) {
            for (Permission permission : permissions) {
                this.result.permissions.add(permission);
            }
            return this;
        }

        public Builder permissions(String ... permissions) {
            for (String permission : permissions) {
                this.result.permissions.add(new Permission(permission));
            }
            return this;
        }

        public Builder permissions(Collection<Permission> permissions) {
            this.result.permissions.addAll(permissions);
            return this;
        }

        public AuthorizationProviderResult create() {
            if (this.result.userIdType == null || this.result.userId == null) {
                throw new IllegalArgumentException("Missing identity");
            }
            return this.result;
        }
    }
}

