/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authorization;

import com.ericsson.lwac.security.authorization.UnsupportedTOTPAuthTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlEnum
@XmlType(namespace="http://www.ericsson.com/lwac/security/authorization/common", name="totpauthtype")
public enum TOTPAuthType {
    TOTP("totp"),
    TOTP_RESET("totp_reset");

    private static final Map<String, TOTPAuthType> totpAuthTypes;
    private final String name;

    private TOTPAuthType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static TOTPAuthType fromString(String text) {
        TOTPAuthType totpAuthType = totpAuthTypes.get(text);
        if (totpAuthType == null) {
            throw new UnsupportedTOTPAuthTypeException("unsupported_TOTP_auth_type");
        }
        return totpAuthType;
    }

    static {
        HashMap<String, TOTPAuthType> temptotpMap = new HashMap<String, TOTPAuthType>();
        for (TOTPAuthType totpAuthType : TOTPAuthType.values()) {
            temptotpMap.put(totpAuthType.toString(), totpAuthType);
        }
        totpAuthTypes = Collections.unmodifiableMap(temptotpMap);
    }
}

