/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.service;

public class CertificateSigningOptions {
    private final int validityDays;
    private final boolean tlsClientAuth;
    private final boolean tlsServerAuth;

    private CertificateSigningOptions(Builder builder) {
        this.validityDays = builder.validityDays;
        this.tlsClientAuth = builder.tlsClientAuth;
        this.tlsServerAuth = builder.tlsServerAuth;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public boolean isTlsClientAuth() {
        return this.tlsClientAuth;
    }

    public boolean isTlsServerAuth() {
        return this.tlsServerAuth;
    }

    public static final class Builder {
        private int validityDays;
        private boolean tlsClientAuth;
        private boolean tlsServerAuth;

        private Builder() {
        }

        public Builder validityDays(int val) {
            this.validityDays = val;
            return this;
        }

        public Builder tlsClientAuth(boolean val) {
            this.tlsClientAuth = val;
            return this;
        }

        public Builder tlsServerAuth(boolean val) {
            this.tlsServerAuth = val;
            return this;
        }

        public CertificateSigningOptions build() {
            return new CertificateSigningOptions(this);
        }
    }
}

