/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.service;

import com.ericsson.lwac.actions.UnaryAction;
import com.ericsson.lwac.security.service.CertificateBuilder;
import com.ericsson.lwac.security.service.SecurityProviderException;
import com.ericsson.lwac.security.service.SecurityProviderListener;
import com.ericsson.lwac.security.service.SignatureProvider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.concurrent.Callable;
import javax.crypto.SecretKey;

public interface SecurityService {
    public KeyStore getKeystore();

    public KeyStore getTruststore();

    public SecureRandom getSecureRandom();

    public void checkClientCertificateTrusted(X509Certificate[] var1) throws CertificateException;

    public void addKeystoreEntry(String var1, KeyStore.Entry var2);

    public void deleteKeystoreEntry(String var1);

    public void generateSecretKey(String var1, String var2, Integer var3, Boolean var4);

    public void generateTransientSecretKey(String var1, String var2, Integer var3);

    @Deprecated
    public void generateRsaKeypairAndSelfsignedCert(String var1, Integer var2, String var3, Integer var4, String var5, boolean var6);

    @Deprecated
    public void generateRsaKeypairAndCACert(String var1, Integer var2, String var3, Integer var4, String var5);

    @Deprecated
    public byte[] createRsaCertificateRequest(String var1, Integer var2, String var3, Integer var4, String var5, boolean var6);

    public void updateCertificateChain(String var1, Certificate[] var2);

    public List<String> getSecretKeyAliases(boolean var1);

    public SecretKey getSecretKey(String var1);

    public PrivateKey getPrivateKey(String var1);

    public Certificate getCertificate(String var1);

    public boolean containsKey(String var1);

    public void deleteKey(String var1);

    public void loadSecretKey(String var1);

    public byte[] wrapSecretKey(String var1, String var2, String var3, byte[] var4);

    public byte[] wrapSecretKeyWithPublicKey(String var1, PublicKey var2, String var3);

    public void unwrapSecretKey(String var1, byte[] var2, String var3, String var4, String var5, byte[] var6);

    public byte[] encryptSymmetric(byte[] var1, byte[] var2, String var3, String var4);

    public byte[] encryptSymmetric(byte[] var1, String var2, String var3, AlgorithmParameterSpec var4);

    public byte[] decryptSymmetric(byte[] var1, byte[] var2, String var3, String var4);

    public byte[] decryptSymmetric(byte[] var1, String var2, String var3, AlgorithmParameterSpec var4);

    public byte[] createSymmetricSignature(byte[] var1, String var2, String var3);

    public boolean verifySymmetricSignature(byte[] var1, byte[] var2, String var3, String var4);

    public byte[] createSaltedHash(byte[] var1, byte[] var2, String var3, String var4);

    public Signature getInitializedSignature(String var1, String var2);

    public Signature getUninitializedRsaSignature(String var1);

    public void reload();

    public void addSecurityProviderListener(SecurityProviderListener var1);

    public <T> T runWithoutFingerprintVerification(Callable<T> var1) throws Exception;

    public String getRsaSignerProviderName();

    public boolean isRunWithoutFingerprintVerification();

    public void registerSignatureProvider(SignatureProvider var1);

    public Signature getInitializedSignatureForVerification(String var1, String var2);

    public void writeKeyStore(UnaryAction.UnaryVoidAction<KeyStore, SecurityProviderException> var1) throws SecurityProviderException;

    public CertificateBuilder newCertificateBuilder();

    public static enum SecurityProviderNotification {
        DISCONNECTED,
        RECONNECTED;

    }
}

