/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.timer;

import com.ericsson.lwac.deployer.BeanId;
import com.ericsson.lwac.timer.TimerCondition;
import com.ericsson.lwac.timer.TimerListener;
import jakarta.annotation.Nullable;

public final class TimerRegistration {
    private final TimerCondition timerCondition;
    private final BeanId beanId;
    private final String suffix;
    private final String pattern;
    private final TimerListener timerListener;
    private final boolean interruptible;
    private final Integer priority;

    private TimerRegistration(TimerRegistrationBuilder builder) {
        this.beanId = builder.beanId;
        this.suffix = builder.suffix;
        this.timerListener = builder.timerListener;
        this.pattern = builder.pattern;
        this.timerCondition = builder.timerCondition;
        this.interruptible = builder.interruptible;
        this.priority = builder.priority;
    }

    TimerCondition getTimerCondition() {
        return this.timerCondition;
    }

    BeanId getBeanId() {
        return this.beanId;
    }

    @Nullable
    String getSuffix() {
        return this.suffix;
    }

    String getPattern() {
        return this.pattern;
    }

    TimerListener getTimerListener() {
        return this.timerListener;
    }

    boolean isInterruptable() {
        return this.interruptible;
    }

    @Nullable
    Integer getPriority() {
        return this.priority;
    }

    public static TimerRegistrationBuilder newBuilder() {
        return new TimerRegistrationBuilder();
    }

    public static TimerRegistrationBuilder buildUpon(TimerRegistration original) {
        TimerRegistrationBuilder builder = TimerRegistration.newBuilder();
        builder.timerCondition(original.getTimerCondition());
        builder.beanId(original.getBeanId());
        builder.suffix(original.getSuffix());
        builder.pattern(original.getPattern());
        builder.timerListener(original.getTimerListener());
        builder.priority(original.getPriority());
        return builder;
    }

    public static class TimerRegistrationBuilder {
        private BeanId beanId;
        private String suffix;
        private TimerListener timerListener;
        private String pattern;
        private TimerCondition timerCondition;
        private boolean interruptible = true;
        private Integer priority;

        public TimerRegistrationBuilder beanId(BeanId value) {
            this.beanId = value;
            return this;
        }

        public TimerRegistrationBuilder suffix(String value) {
            this.suffix = value;
            return this;
        }

        public TimerRegistrationBuilder timerListener(TimerListener value) {
            this.timerListener = value;
            return this;
        }

        public TimerRegistrationBuilder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public TimerRegistrationBuilder timerCondition(TimerCondition value) {
            this.timerCondition = value;
            return this;
        }

        public TimerRegistrationBuilder interruptible(boolean value) {
            this.interruptible = value;
            return this;
        }

        public TimerRegistrationBuilder priority(Integer value) {
            this.priority = value;
            return this;
        }

        public TimerRegistration build() {
            if (this.beanId == null) {
                throw new IllegalArgumentException("BeanId is mandatory");
            }
            if (this.timerListener == null) {
                throw new IllegalArgumentException("TimerListener is mandatory");
            }
            if (this.pattern == null) {
                throw new IllegalArgumentException("Pattern is mandatory");
            }
            if (this.timerCondition == null) {
                throw new IllegalArgumentException("TimerCondition is mandatory");
            }
            if (this.priority != null && this.priority <= 0) {
                throw new IllegalArgumentException("Priority must be greater than zero");
            }
            return new TimerRegistration(this);
        }
    }
}

