/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.transaction;

import com.ericsson.lwac.transaction.TransactionPriority;
import com.ericsson.lwac.transaction.TransactionType;
import java.util.concurrent.TimeUnit;

public final class UnstartedTransaction {
    private final long timeout;
    private final TimeUnit timeUnit;
    private final boolean forceCommit;
    private final boolean defaultTimeout;
    private final TransactionPriority transactionPriority;
    private final boolean detached;
    private final boolean assumeUpdated;
    private final TransactionType transactionType;

    private UnstartedTransaction(Builder builder) {
        this.timeout = builder.timeout;
        this.timeUnit = builder.timeUnit;
        this.forceCommit = builder.forceCommit;
        this.defaultTimeout = builder.defaultTimeout;
        this.transactionPriority = builder.transactionPriority;
        this.detached = builder.detached;
        this.assumeUpdated = builder.assumeUpdated;
        this.transactionType = builder.transactionType;
    }

    boolean useDefaultTimeout() {
        return this.defaultTimeout;
    }

    long getTimeout() {
        return this.timeout;
    }

    TimeUnit getTimeoutTimeUnit() {
        return this.timeUnit;
    }

    boolean isForceCommit() {
        return this.forceCommit;
    }

    TransactionPriority getTransactionPriority() {
        return this.transactionPriority;
    }

    boolean isDetached() {
        return this.detached;
    }

    public boolean isAssumeUpdated() {
        return this.assumeUpdated;
    }

    TransactionType getTransactionType() {
        return this.transactionType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static UnstartedTransaction createWithTimeout(long timeout, TimeUnit timeUnit) {
        return new Builder().timeout(timeout, timeUnit).create();
    }

    public static UnstartedTransaction createWithDefaultTimeout() {
        return new Builder().defaultTimeout().create();
    }

    public static final class Builder {
        private long timeout;
        private TimeUnit timeUnit;
        private boolean forceCommit = false;
        private boolean defaultTimeout = false;
        private TransactionPriority transactionPriority = TransactionPriority.NORMAL;
        private boolean detached = false;
        private boolean assumeUpdated = false;
        private TransactionType transactionType = TransactionType.READ_WRITE;

        private Builder() {
        }

        public Builder timeout(long timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder forceCommit(boolean val) {
            this.forceCommit = val;
            return this;
        }

        public Builder defaultTimeout() {
            this.defaultTimeout = true;
            return this;
        }

        public Builder transactionPriority(TransactionPriority val) {
            this.transactionPriority = val;
            return this;
        }

        public Builder detached() {
            this.detached = true;
            return this;
        }

        public Builder assumeUpdated() {
            this.assumeUpdated = true;
            return this;
        }

        public Builder transactionType(TransactionType val) {
            this.transactionType = val;
            return this;
        }

        @Deprecated
        public UnstartedTransaction create() {
            return this.build();
        }

        public UnstartedTransaction build() {
            if (this.defaultTimeout) {
                if (this.timeout != 0L || this.timeUnit != null) {
                    throw new IllegalArgumentException("Default timeout and time set together");
                }
            } else if (this.timeout < 1L || this.timeUnit == null) {
                throw new IllegalArgumentException(String.format("Timeout was not set correctly (timeout: %d timeunit: %s)", new Object[]{this.timeout, this.timeUnit}));
            }
            return new UnstartedTransaction(this);
        }
    }
}

