/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.BaseEncryption;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessPrivateStaticFinalField {
    private static final String MEMBER_NAME = "java.lang.invoke.MemberName";
    private static final String FLAGS = "flags";
    private static final String MODIFIERS = "modifiers";
    private static final String DECLARED_FIELD = "getDeclaredFields0";
    private static final String REFERENCED_KIND = "getReferenceKind";
    private static final String COMMON_FIELD = "getDirectFieldCommon";
    private static final Logger logger = LoggerFactory.getLogger(BaseEncryption.class);

    private AccessPrivateStaticFinalField() {
        throw new UnsupportedOperationException("AccessPrivateStaticFinalField class cannot be instantiated");
    }

    public static void setPrivateStaticFinalField(Class<?> clazz, String classFieldName, Object newValue) {
        try {
            Field myStaticFinalField = clazz.getDeclaredField(classFieldName);
            myStaticFinalField.setAccessible(true);
            AccessPrivateStaticFinalField.removeFinalNess(myStaticFinalField);
            Class<?> memberNameClass = Class.forName(MEMBER_NAME);
            Constructor<?> memberNameConstructor = memberNameClass.getDeclaredConstructor(Field.class, Boolean.TYPE);
            memberNameConstructor.setAccessible(true);
            Object memberNameInstanceForField = memberNameConstructor.newInstance(myStaticFinalField, true);
            Field memberNameFlagsField = memberNameClass.getDeclaredField(FLAGS);
            memberNameFlagsField.setAccessible(true);
            memberNameFlagsField.setInt(memberNameInstanceForField, memberNameFlagsField.getInt(memberNameInstanceForField) & 0xFFFFFFEF);
            Method getReferenceKindMethod = memberNameClass.getDeclaredMethod(REFERENCED_KIND, new Class[0]);
            getReferenceKindMethod.setAccessible(true);
            byte getReferenceKind = (Byte)getReferenceKindMethod.invoke(memberNameInstanceForField, new Object[0]);
            MethodHandles.Lookup mh = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
            Method getDirectFieldCommonMethod = mh.getClass().getDeclaredMethod(COMMON_FIELD, Byte.TYPE, Class.class, memberNameClass, Boolean.TYPE);
            getDirectFieldCommonMethod.setAccessible(true);
            MethodHandle o = (MethodHandle)getDirectFieldCommonMethod.invoke((Object)mh, getReferenceKind, myStaticFinalField.getDeclaringClass(), memberNameInstanceForField, false);
            o.invoke(newValue);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            logger.error("Unexpected error has occured", t);
            throw new RuntimeException(t);
        }
    }

    private static void removeFinalNess(Field field) throws Throwable {
        Method[] classMethods = Class.class.getDeclaredMethods();
        Method declaredFieldMethod = Arrays.stream(classMethods).filter(x -> Objects.equals(x.getName(), DECLARED_FIELD)).findAny().orElseThrow();
        declaredFieldMethod.setAccessible(true);
        Field[] declaredFieldsOfField = (Field[])declaredFieldMethod.invoke(Field.class, false);
        Field modifiersField = Arrays.stream(declaredFieldsOfField).filter(x -> Objects.equals(x.getName(), MODIFIERS)).findAny().orElseThrow();
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }
}

