/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseEncryption {
    private static final String AES_METHOD = "AES";
    private static final String AES_METHOD_PADDING = "AES/CBC/PKCS5Padding";
    private static final int AES_KEY_SIZE = 256;
    private static final int IV_SIZE = 16;
    public static final String JCE_PROVIDER = "SunJCE";
    public static final String RSA_METHOD = "RSA";
    public static final String RSA_METHOD_PADDING = "RSA/ECB/PKCS1Padding";
    public static final String RSA_PROVIDER = "SunRsaSign";
    private static final Logger logger = LoggerFactory.getLogger(BaseEncryption.class);

    private BaseEncryption() {
        throw new IllegalStateException("Utility class, can not instantiate");
    }

    public static Cipher createAesCipher(IvParameterSpec iv, SecretKey key) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(AES_METHOD_PADDING);
            cipher.init(1, (Key)key, iv);
        }
        catch (Exception e) {
            logger.error("Unexpected exception during creation of AES cipher", e);
        }
        return cipher;
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[1024];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
    }

    public static void fill(InputStream ios, byte[] buffer) throws IOException {
        int read;
        for (int start = 0; start < buffer.length; start += read) {
            read = ios.read(buffer, start, buffer.length - start);
            if (read != -1) continue;
            throw new IOException("End of buffer reached");
        }
    }

    public static String encrypt(Cipher cipher, String text) {
        try {
            return Base64.getEncoder().encodeToString(cipher.doFinal(text.getBytes(Charset.defaultCharset())));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            logger.error("Error during encrypting", e);
            return "";
        }
    }

    public static String decrypt(SecretKey key, String text, IvParameterSpec iv) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance(AES_METHOD_PADDING);
            cipher.init(2, (Key)key, iv);
            return new String(cipher.doFinal(Base64.getDecoder().decode(text)));
        }
        catch (Exception e) {
            throw new IOException("Unexpected exception during AES decrypting", e);
        }
    }

    public static byte[] encryptSecretKey(SecretKey aesKey, RSAPublicKey publicKey) throws IOException {
        try {
            Cipher pkCipher = Cipher.getInstance(RSA_METHOD_PADDING);
            pkCipher.init(3, publicKey);
            return pkCipher.wrap(aesKey);
        }
        catch (Exception e) {
            throw new IOException("Bad key");
        }
    }

    public static SecretKey decryptSecretKey(byte[] encryptedAesKey, RSAPrivateKey privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher pkCipher = Cipher.getInstance(RSA_METHOD_PADDING);
        pkCipher.init(4, privateKey);
        Key key = pkCipher.unwrap(encryptedAesKey, AES_METHOD, 3);
        return (SecretKey)key;
    }

    public static byte[] encryptAesKeyAndIv(SecretKey aesKey, IvParameterSpec iv, RSAPublicKey pubKey) throws IOException {
        try {
            Cipher pkCipher = Cipher.getInstance(RSA_METHOD_PADDING);
            pkCipher.init(1, pubKey);
            StringBuilder content = new StringBuilder(1024);
            content.append(Hex.toHexString(aesKey.getEncoded()).toUpperCase());
            content.append("\n");
            content.append(Hex.toHexString(iv.getIV()).toUpperCase());
            content.append("\n");
            return pkCipher.doFinal(content.toString().getBytes());
        }
        catch (Exception e) {
            throw new IOException("Unexpected exception during AES key and IV encrypting", e);
        }
    }

    public static RSAPublicKey getPublicKeyFromStream(InputStream in, byte[] encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BaseEncryption.fill(in, encodedKey);
        return BaseEncryption.getPublicKey(encodedKey);
    }

    public static RSAPublicKey getPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory fact = KeyFactory.getInstance(RSA_METHOD);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encodedKey);
        return (RSAPublicKey)fact.generatePublic(pubKeySpec);
    }

    public static RSAPrivateKey getPrivateKeyFromStream(InputStream in, byte[] encodedKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BaseEncryption.fill(in, encodedKey);
        KeyFactory kf = KeyFactory.getInstance(RSA_METHOD);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedKey);
        return (RSAPrivateKey)kf.generatePrivate(privateKeySpec);
    }

    public static SecretKey makeAESKey() throws NoSuchAlgorithmException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES_METHOD);
            kgen.init(256);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Bad combination of algorithm and provider");
            throw e;
        }
    }

    public static IvParameterSpec createInitializationVectorWithSpecifiedSize(String text) {
        byte[] bytes = text.getBytes();
        byte[] ivBytes = new byte[16];
        if (bytes.length > 16) {
            ivBytes = Arrays.copyOfRange(bytes, 0, 16);
        } else if (bytes.length < 16) {
            int paddingSize = 16 - bytes.length;
            System.arraycopy(bytes, 0, ivBytes, paddingSize, bytes.length);
        } else {
            ivBytes = bytes;
        }
        return new IvParameterSpec(ivBytes);
    }

    public static String getAesMethod() {
        return AES_METHOD;
    }
}

