/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import org.joda.time.DateTime;

public class DatePatternMatcher {
    private static final int NUM_OF_CRON_FIELDS = 5;
    private static final int CRON_MINUTE = 0;
    private static final int CRON_HOUR = 1;
    private static final int CRON_DAY_OF_MONTH = 2;
    private static final int CRON_MONTH = 3;
    private static final int CRON_DAY_OF_WEEK = 4;

    public boolean match(LocalDateTime date, String pattern) {
        return this.match(Date.from(date.atZone(ZoneId.systemDefault()).toInstant()), pattern);
    }

    public boolean match(ZonedDateTime date, String pattern) {
        return this.match(Date.from(date.toInstant()), pattern);
    }

    @Deprecated
    public boolean match(DateTime date, String pattern) {
        return this.match(date.toDate(), pattern);
    }

    @Deprecated
    public boolean match(Date date, String pattern) {
        String[] fields = this.validateAndGet(pattern);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return this.match(fields[0], gregorianCalendar.get(12)) && this.match(fields[1], gregorianCalendar.get(11)) && this.match(fields[2], gregorianCalendar.get(5)) && this.match(fields[3], gregorianCalendar.get(2) + 1) && this.match(fields[4], gregorianCalendar.get(7) - 1);
    }

    public void validate(String pattern) {
        this.validateAndGet(pattern);
    }

    public String[] validateAndGet(String pattern) {
        String[] fields = pattern.split(" ");
        if (fields.length != 5) {
            throw new IllegalArgumentException("Could not parse pattern: " + pattern);
        }
        return fields;
    }

    boolean match(String part, int matchingNumber) {
        boolean result;
        block3: {
            String[] subParts;
            block4: {
                block2: {
                    result = false;
                    if (!"*".equals(part)) break block2;
                    result = true;
                    break block3;
                }
                if (!part.contains("*/")) break block4;
                int divider = Integer.parseInt(part.split("/")[1]);
                if (matchingNumber % divider != 0) break block3;
                result = true;
                break block3;
            }
            for (String subPart : subParts = part.split(",")) {
                if (subPart.contains("-")) {
                    String[] numbers = subPart.split("-");
                    if (Integer.parseInt(numbers[0]) > matchingNumber || matchingNumber > Integer.parseInt(numbers[1])) continue;
                    result = true;
                    break;
                }
                int number = Integer.parseInt(subPart);
                if (number != matchingNumber) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public ZonedDateTime getNextJobDate(ZonedDateTime dateTime, String pattern) {
        return this.getNextJobDate(Date.from(dateTime.toInstant()), pattern).toInstant().atZone(dateTime.getZone());
    }

    public LocalDateTime getNextJobDate(LocalDateTime dateTime, String pattern) {
        return this.getNextJobDate(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()), pattern).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Deprecated
    public DateTime getNextJobDate(DateTime dateTime, String pattern) {
        Date next = this.getNextJobDate(dateTime.toDate(), pattern);
        return new DateTime(next);
    }

    @Deprecated
    public Date getNextJobDate(Date date, String pattern) {
        String[] fields = this.validateAndGet(pattern);
        boolean isMonthMatched = false;
        boolean isDayOfMonthMatched = false;
        boolean isDayOfWeekMatched = false;
        boolean isHourMatched = false;
        int month = 0;
        int dayOfMonth = 0;
        int dayOfWeek = 0;
        int hour = 0;
        GregorianCalendar nextJob = new GregorianCalendar();
        nextJob.setTime(date);
        nextJob.add(12, 1);
        while (true) {
            if (!isMonthMatched) {
                if (this.match(fields[3], nextJob.get(2) + 1)) {
                    isMonthMatched = true;
                    month = nextJob.get(2);
                } else {
                    nextJob.add(2, 1);
                    nextJob.set(5, 1);
                    nextJob.set(11, 0);
                    nextJob.set(12, 0);
                    continue;
                }
            }
            if (!isDayOfMonthMatched) {
                if (this.match(fields[2], nextJob.get(5))) {
                    if (nextJob.get(2) != month) {
                        isMonthMatched = false;
                        continue;
                    }
                    isDayOfMonthMatched = true;
                    dayOfMonth = nextJob.get(5);
                } else {
                    nextJob.add(5, 1);
                    nextJob.set(11, 0);
                    nextJob.set(12, 0);
                    continue;
                }
            }
            if (!isDayOfWeekMatched) {
                if (this.match(fields[4], nextJob.get(7) - 1)) {
                    if (nextJob.get(2) != month || nextJob.get(5) != dayOfMonth) {
                        isMonthMatched = false;
                        isDayOfMonthMatched = false;
                        continue;
                    }
                    isDayOfWeekMatched = true;
                    dayOfWeek = nextJob.get(7);
                } else {
                    nextJob.add(7, 1);
                    nextJob.set(11, 0);
                    nextJob.set(12, 0);
                    continue;
                }
            }
            if (!isHourMatched) {
                if (this.match(fields[1], nextJob.get(11))) {
                    if (nextJob.get(2) != month || nextJob.get(5) != dayOfMonth || nextJob.get(7) != dayOfWeek) {
                        isMonthMatched = false;
                        isDayOfMonthMatched = false;
                        isDayOfWeekMatched = false;
                        continue;
                    }
                    isHourMatched = true;
                    hour = nextJob.get(11);
                } else {
                    nextJob.add(11, 1);
                    nextJob.set(12, 0);
                    continue;
                }
            }
            if (this.match(fields[0], nextJob.get(12))) {
                if (nextJob.get(2) == month && nextJob.get(5) == dayOfMonth && nextJob.get(7) == dayOfWeek && nextJob.get(11) == hour) break;
                isMonthMatched = false;
                isDayOfMonthMatched = false;
                isDayOfWeekMatched = false;
                isHourMatched = false;
                continue;
            }
            nextJob.add(12, 1);
        }
        return nextJob.getTime();
    }

    public DateTime getPreviousJobDate(DateTime dateTime, String pattern) {
        Date next = this.getPreviousJobDate(dateTime.toDate(), pattern);
        return new DateTime(next);
    }

    public Date getPreviousJobDate(Date date, String pattern) {
        String[] fields = this.validateAndGet(pattern);
        boolean isMonthMatched = false;
        boolean isDayOfMonthMatched = false;
        boolean isDayOfWeekMatched = false;
        boolean isHourMatched = false;
        int month = 0;
        int dayOfMonth = 0;
        int dayOfWeek = 0;
        int hour = 0;
        GregorianCalendar prevJob = new GregorianCalendar();
        prevJob.setTime(date);
        prevJob.add(12, -1);
        while (true) {
            if (!isMonthMatched) {
                if (this.match(fields[3], prevJob.get(2) + 1)) {
                    isMonthMatched = true;
                    month = prevJob.get(2);
                } else {
                    prevJob.add(2, -1);
                    prevJob.set(5, prevJob.getActualMaximum(5));
                    prevJob.set(11, prevJob.getActualMaximum(11));
                    prevJob.set(12, prevJob.getActualMaximum(12));
                    continue;
                }
            }
            if (!isDayOfMonthMatched) {
                if (this.match(fields[2], prevJob.get(5))) {
                    if (prevJob.get(2) != month) {
                        isMonthMatched = false;
                        continue;
                    }
                    isDayOfMonthMatched = true;
                    dayOfMonth = prevJob.get(5);
                } else {
                    prevJob.add(5, -1);
                    prevJob.set(11, prevJob.getActualMaximum(11));
                    prevJob.set(12, prevJob.getActualMaximum(12));
                    continue;
                }
            }
            if (!isDayOfWeekMatched) {
                if (this.match(fields[4], prevJob.get(7) - 1)) {
                    if (prevJob.get(2) != month || prevJob.get(5) != dayOfMonth) {
                        isMonthMatched = false;
                        isDayOfMonthMatched = false;
                        continue;
                    }
                    isDayOfWeekMatched = true;
                    dayOfWeek = prevJob.get(7);
                } else {
                    prevJob.add(7, -1);
                    prevJob.set(11, prevJob.getActualMaximum(11));
                    prevJob.set(12, prevJob.getActualMaximum(12));
                    continue;
                }
            }
            if (!isHourMatched) {
                if (this.match(fields[1], prevJob.get(11))) {
                    if (prevJob.get(2) != month || prevJob.get(5) != dayOfMonth || prevJob.get(7) != dayOfWeek) {
                        isMonthMatched = false;
                        isDayOfMonthMatched = false;
                        isDayOfWeekMatched = false;
                        continue;
                    }
                    isHourMatched = true;
                    hour = prevJob.get(11);
                } else {
                    prevJob.add(11, -1);
                    prevJob.set(12, prevJob.getActualMaximum(12));
                    continue;
                }
            }
            if (this.match(fields[0], prevJob.get(12))) {
                if (prevJob.get(2) == month && prevJob.get(5) == dayOfMonth && prevJob.get(7) == dayOfWeek && prevJob.get(11) == hour) break;
                isMonthMatched = false;
                isDayOfMonthMatched = false;
                isDayOfWeekMatched = false;
                isHourMatched = false;
                continue;
            }
            prevJob.add(12, -1);
        }
        return prevJob.getTime();
    }
}

