/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateUtilities {
    private DateUtilities() {
    }

    @Deprecated
    public static XMLGregorianCalendar newXMLGregorianCalendarFromLocalDate(LocalDate date) {
        XMLGregorianCalendar xmlCal;
        try {
            xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException x) {
            throw new RuntimeException("Serious configuration error, XMLGregorianCalendar not found.", x);
        }
        return xmlCal;
    }

    @Deprecated
    public static Date add(Date date, int field, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(field, amount);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date add(Date date, int amount, TimeUnit timeUnit) {
        return new Date(date.getTime() + timeUnit.toMillis(amount));
    }

    public static String formatElapsedTime(long millis) {
        long n = millis;
        long days = (n /= 1000L) / 86400L;
        long hours = n % 86400L / 3600L;
        long minutes = n % 3600L / 60L;
        long seconds = n % 60L;
        StringBuilder builder = new StringBuilder();
        if (days != 0L) {
            builder.append(days).append("d ");
        }
        if (hours != 0L || days != 0L) {
            builder.append(DateUtilities.twoDigit(hours)).append("h ");
        }
        if (minutes != 0L || hours != 0L || days != 0L) {
            builder.append(DateUtilities.twoDigit(minutes)).append("m ");
        }
        builder.append(DateUtilities.twoDigit(seconds)).append("s");
        return builder.toString();
    }

    public static String formatElapsedTimeMillis(long millis) {
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long minutes = millis % 3600000L / 60000L;
        long seconds = millis % 60000L / 1000L;
        StringBuilder builder = new StringBuilder();
        if (days != 0L) {
            builder.append(days).append("d ");
        }
        if (hours != 0L || days != 0L) {
            builder.append(DateUtilities.twoDigit(hours)).append("h ");
        }
        if (minutes != 0L || hours != 0L || days != 0L) {
            builder.append(DateUtilities.twoDigit(minutes)).append("m ");
        }
        if (minutes != 0L || hours != 0L || days != 0L || seconds != 0L) {
            builder.append(DateUtilities.twoDigit(seconds)).append("s ");
            builder.append(DateUtilities.threeDigit(millis % 1000L)).append("ms");
        } else {
            builder.append(millis % 1000L).append("ms");
        }
        return builder.toString();
    }

    private static String twoDigit(long digit) {
        return digit < 10L ? "0" + digit : "" + digit;
    }

    private static String threeDigit(long digit) {
        return digit < 10L ? "00" + digit : (digit < 100L ? "0" + digit : "" + digit);
    }

    public static String getCurrentReadableDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ROOT);
        return dateFormat.format(new Date());
    }

    public static String getCurrentReadableDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT);
        return dateFormat.format(new Date());
    }

    @Deprecated
    public static Date addMonth(Date date, int amount, int dayOfMonth) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(2, amount);
        int actualMaximum = calendar.getActualMaximum(5);
        calendar.set(5, Math.min(dayOfMonth, actualMaximum));
        return new Date(calendar.getTimeInMillis());
    }

    public static <T extends ReadableInstant> T getMax(T first, T second) {
        if (first == null) {
            return first;
        }
        if (second == null) {
            return second;
        }
        if (first.isAfter(second)) {
            return first;
        }
        return second;
    }

    public static <T extends ReadableInstant> T getMin(T first, T second) {
        if (first == null) {
            return first;
        }
        if (second == null) {
            return second;
        }
        if (first.isBefore(second)) {
            return first;
        }
        return second;
    }

    public static boolean within(ReadableInstant startDateTime, ReadableInstant endDateTime, ReadableInstant dateTime) {
        long start = startDateTime == null ? Long.MIN_VALUE : startDateTime.getMillis();
        long end = endDateTime == null ? Long.MAX_VALUE : endDateTime.getMillis();
        long dateTimeMillis = dateTime.getMillis();
        return start <= dateTimeMillis && dateTimeMillis < end;
    }

    public static String getReadableDateAndTime(ReadableInstant dateTime) {
        return DateUtilities.formatWithPattern(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    private static String formatWithPattern(ReadableInstant dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern(pattern);
        return formatter.print(dateTime);
    }

    public static String getReadableDate(ReadableInstant dateTime) {
        return DateUtilities.formatWithPattern(dateTime, "yyyy-MM-dd");
    }

    public static DateTime parseReadableDateAndTimeAsDateTime(String date) {
        return DateUtilities.parseToDateTime(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static DateTime parseReadableDateAsDateTime(String date) {
        return DateUtilities.parseToDateTime(date, "yyyy-MM-dd");
    }

    private static DateTime parseToDateTime(String date, String pattern) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern(pattern);
        DateTime value = null;
        try {
            value = dateFormat.parseDateTime(date);
        }
        catch (IllegalArgumentException e) {
            value = null;
        }
        return value;
    }
}

