/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;

public class ExecSpec {
    private Writer stdOut = new StringWriter();
    private Reader stdIn = new StringReader("");
    private Writer stdErr;
    private String[] commandLine;
    private boolean ignoreErrors = false;

    public ExecSpec stdOut(Writer stdOut) {
        this.stdOut = stdOut;
        return this;
    }

    public ExecSpec stdIn(Reader stdIn) {
        this.stdIn = stdIn;
        return this;
    }

    public ExecSpec ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public ExecSpec commandLine(String ... commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public ExecSpec stdIn(InputStream in) {
        this.stdIn = new InputStreamReader(in);
        return this;
    }

    public ExecSpec stdErr(Writer stdErr) {
        this.stdErr = stdErr;
        return this;
    }

    public Writer getStdOut() {
        return this.stdOut;
    }

    public Reader getStdIn() {
        return this.stdIn;
    }

    public Writer getStdErr() {
        return this.stdErr;
    }

    public String[] getCommandLine() {
        return Arrays.copyOf(this.commandLine, this.commandLine.length);
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }
}

