/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesUtilities {
    private PropertiesUtilities() {
    }

    public static String expandString(String string, Properties values) {
        return PropertiesUtilities.expandString(string, new HashMap<Object, Object>(values));
    }

    public static String expandString(String string, Map<String, String> values) {
        Matcher m;
        if (string == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(string);
        Pattern p = Pattern.compile("\\$\\{([^}^$]+?)}");
        while ((m = p.matcher(result.toString())).find()) {
            String key;
            String group = m.group(1);
            String defaultValue = null;
            int defaultIndex = group.indexOf(58);
            if (defaultIndex != -1) {
                key = group.substring(0, defaultIndex);
                defaultValue = group.substring(defaultIndex + 1);
            } else {
                key = group;
            }
            if (values.get(key) != null) {
                result.replace(m.start(), m.end(), values.get(key));
                continue;
            }
            if (defaultValue != null) {
                result.replace(m.start(), m.end(), defaultValue);
                continue;
            }
            throw new IllegalArgumentException("Missing value of variable " + group);
        }
        return result.toString();
    }

    public static String expandString(String string, String key, String value) {
        StringBuilder result = new StringBuilder(string);
        String keyString = "${" + key + "}";
        int start = string.indexOf(keyString);
        while (start != -1) {
            result.replace(start, start + keyString.length(), value);
            start = result.indexOf(keyString, start + value.length());
        }
        return result.toString();
    }
}

