/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.Map;

public class PropertyFilterReader
extends Reader {
    private final StringReader mWrappedReader;

    public PropertyFilterReader(Reader reader, Map<String, String> properties) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line).append("\n");
            }
        }
        String result = builder.toString();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            result = result.replaceAll("\\$\\{" + entry.getKey() + "\\}", entry.getValue());
        }
        this.mWrappedReader = new StringReader(result);
    }

    @Override
    public int read() throws IOException {
        return this.mWrappedReader.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.mWrappedReader.read(cbuf, off, len);
    }

    public int hashCode() {
        return this.mWrappedReader.hashCode();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.mWrappedReader.read(target);
    }

    @Override
    public long skip(long ns) throws IOException {
        return this.mWrappedReader.skip(ns);
    }

    @Override
    public boolean ready() throws IOException {
        return this.mWrappedReader.ready();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.mWrappedReader.read(cbuf);
    }

    public boolean equals(Object obj) {
        return this.mWrappedReader.equals(obj);
    }

    @Override
    public boolean markSupported() {
        return this.mWrappedReader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.mWrappedReader.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.mWrappedReader.reset();
    }

    @Override
    public void close() {
        this.mWrappedReader.close();
    }

    public String toString() {
        return this.mWrappedReader.toString();
    }
}

