/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlClassPathAggregateResourceBundleLocator {
    private static final Logger logger = LoggerFactory.getLogger(UrlClassPathAggregateResourceBundleLocator.class);
    private static final String BUNDLE_NAME = "ValidationMessages";
    private final Map<String, URL> classPaths;
    private final ConcurrentMap<Locale, ResourceBundle> resourceBundles = new ConcurrentHashMap<Locale, ResourceBundle>();

    public UrlClassPathAggregateResourceBundleLocator() {
        this.classPaths = Collections.unmodifiableMap(new LinkedHashMap<String, URL>(UrlClassPathAggregateResourceBundleLocator.getValidationResources()));
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = (ResourceBundle)this.resourceBundles.get(locale);
        if (resourceBundle == null) {
            ArrayList<ResourceBundle> sourceBundles = new ArrayList<ResourceBundle>();
            ResourceBundle oneBundle = null;
            ClassLoader classLoader = GetClassLoader.fromContext().run();
            if (classLoader != null) {
                oneBundle = this.loadBundle(classLoader, locale, " not found by validator classloader");
            }
            if (oneBundle == null) {
                ClassLoader aClassLoader = GetClassLoader.fromContext().run();
                oneBundle = this.loadBundle(aClassLoader, locale, " not found by thread local classloader");
            }
            if (oneBundle != null) {
                sourceBundles.add(oneBundle);
                logger.debug("{} found in application classpath", (Object)BUNDLE_NAME);
            }
            for (Map.Entry<String, URL> entry : this.classPaths.entrySet()) {
                URL url = entry.getValue();
                classLoader = GetClassLoader.fromURL(new URL[]{url}).run();
                oneBundle = this.loadBundle(classLoader, locale, " not found by URL classloader (" + url.getFile() + ")");
                if (oneBundle == null) continue;
                sourceBundles.add(oneBundle);
                logger.debug("{} found by URL classloader ({})", (Object)BUNDLE_NAME, (Object)url.getFile());
            }
            resourceBundle = new UrlClassPathAggregateBundle(sourceBundles);
            this.resourceBundles.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(BUNDLE_NAME, locale, classLoader);
        }
        catch (MissingResourceException e) {
            logger.trace("{}{}", (Object)BUNDLE_NAME, (Object)message);
        }
        return rb;
    }

    private static Map<String, URL> getValidationResources() {
        LinkedHashMap<String, URL> resourcePaths = new LinkedHashMap<String, URL>();
        ClassLoader classLoader = GetClassLoader.fromContext().run();
        if (classLoader == null) {
            classLoader = GetClassLoader.fromClass(UrlClassPathAggregateResourceBundleLocator.class).run();
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                String key = UrlClassPathAggregateResourceBundleLocator.createKey(url.getFile());
                if (resourcePaths.containsKey(key)) continue;
                resourcePaths.put(key, url);
            }
        }
        for (URL classpathEntry : Arrays.stream(System.getProperty("java.class.path").split(":")).map(UrlClassPathAggregateResourceBundleLocator::createUrl).collect(Collectors.toList())) {
            String key = UrlClassPathAggregateResourceBundleLocator.createKey(classpathEntry.getFile());
            if (resourcePaths.containsKey(key)) continue;
            resourcePaths.put(key, classpathEntry);
        }
        return resourcePaths;
    }

    private static URL createUrl(String classPathEntry) {
        try {
            return new URL("file://" + classPathEntry);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String createKey(String filePath) {
        int cutIndex = filePath.lastIndexOf(File.separatorChar);
        int length = filePath.length();
        if (cutIndex < 0 || cutIndex + 1 == length) {
            return filePath;
        }
        return filePath.substring(cutIndex + 1, length);
    }

    public static final class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;
        private final URL[] urls;

        public static GetClassLoader fromContext() {
            return new GetClassLoader();
        }

        public static GetClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            return new GetClassLoader(clazz);
        }

        public static GetClassLoader fromURL(URL[] urls) {
            if (urls == null) {
                throw new IllegalArgumentException("URL is null");
            }
            return new GetClassLoader(urls);
        }

        private GetClassLoader() {
            this.clazz = null;
            this.urls = null;
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
            this.urls = null;
        }

        private GetClassLoader(URL[] urls) {
            this.clazz = null;
            this.urls = (URL[])urls.clone();
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            if (this.urls != null) {
                return new URLClassLoader(this.urls, null);
            }
            logger.trace("Falling back to Thread.currentThread().getContextClassLoader(), clazz = {}", (Object)this.clazz);
            return Thread.currentThread().getContextClassLoader();
        }
    }

    public static class UrlClassPathAggregateBundle
    extends ResourceBundle {
        private final Map<String, Object> contents = new HashMap<String, Object>();

        public UrlClassPathAggregateBundle(List<ResourceBundle> bundles) {
            if (bundles != null) {
                for (ResourceBundle bundle2 : bundles) {
                    Enumeration<String> keys = bundle2.getKeys();
                    while (keys.hasMoreElements()) {
                        String oneKey = keys.nextElement();
                        Object newValue = bundle2.getObject(oneKey);
                        Object currentValue = this.contents.get(oneKey);
                        if (currentValue == null) {
                            this.contents.put(oneKey, newValue);
                            continue;
                        }
                        if (currentValue.equals(newValue)) continue;
                        logger.warn("Key {} already exists with different value current value '{}' new value '{}'", oneKey, currentValue, newValue);
                    }
                }
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            return new IteratorEnumeration<String>(this.contents.keySet().iterator());
        }

        @Override
        protected Object handleGetObject(@Nonnull String key) {
            return this.contents.get(key);
        }

        public static class IteratorEnumeration<T>
        implements Enumeration<T> {
            private final Iterator<T> source;

            public IteratorEnumeration(Iterator<T> source) {
                if (source == null) {
                    throw new IllegalArgumentException("Source must not be null");
                }
                this.source = source;
            }

            @Override
            public boolean hasMoreElements() {
                return this.source.hasNext();
            }

            @Override
            public T nextElement() {
                return this.source.next();
            }
        }
    }
}

