/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static String getSingleValue(Document document, XPathFactory factory, NamespaceContext namespaceContext, String query) throws XPathExpressionException {
        XPath path = factory.newXPath();
        path.setNamespaceContext(namespaceContext);
        XPathExpression expression = path.compile(query);
        return (String)expression.evaluate(document, XPathConstants.STRING);
    }

    public static int getSingleIntValue(Document document, XPathFactory factory, NamespaceContext namespaceContext, String query) throws XPathExpressionException {
        String text = XmlUtils.getSingleValue(document, factory, namespaceContext, query);
        return Integer.parseInt(text);
    }

    public static NodeList getNodeList(Document document, XPathFactory factory, NamespaceContext namespaceContext, String query) throws XPathExpressionException {
        XPath path = factory.newXPath();
        path.setNamespaceContext(namespaceContext);
        XPathExpression expression = path.compile(query);
        return (NodeList)expression.evaluate(document, XPathConstants.NODESET);
    }

    public static Element getElement(Document document, XPathFactory factory, NamespaceContext namespaceContext, String query) throws XPathExpressionException {
        XPath path = factory.newXPath();
        path.setNamespaceContext(namespaceContext);
        XPathExpression expression = path.compile(query);
        return (Element)expression.evaluate(document, XPathConstants.NODE);
    }

    public static List<String> getMultipleValues(Document document, XPathFactory factory, NamespaceContext namespaceContext, String query) throws XPathExpressionException {
        LinkedList<String> result = new LinkedList<String>();
        XPath path = factory.newXPath();
        path.setNamespaceContext(namespaceContext);
        XPathExpression expression = path.compile(query);
        NodeList list = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < list.getLength(); ++i) {
            result.add(list.item(i).getNodeValue());
        }
        return result;
    }

    public static List<Element> getChildElementList(Element parent) {
        LinkedList<Element> elementList = new LinkedList<Element>();
        NodeList children = parent.getChildNodes();
        for (int ii = 0; ii < children.getLength(); ++ii) {
            if (children.item(ii).getNodeType() != 1) continue;
            elementList.add((Element)children.item(ii));
        }
        return elementList;
    }

    public static List<Element> getElementsByTagName(Element parent, String tagName) {
        LinkedList<Element> elementList = new LinkedList<Element>();
        NodeList elements = parent.getElementsByTagName(tagName);
        for (int ii = 0; ii < elements.getLength(); ++ii) {
            if (elements.item(ii).getNodeType() != 1) continue;
            elementList.add((Element)elements.item(ii));
        }
        return elementList;
    }

    public static List<Element> getChildElementListByName(String tagName, Element parent) {
        LinkedList<Element> elementList = new LinkedList<Element>();
        NodeList children = parent.getChildNodes();
        for (int ii = 0; ii < children.getLength(); ++ii) {
            Node childItem = children.item(ii);
            if (childItem.getNodeType() != 1 || (parent.getOwnerDocument().getNamespaceURI() != null || !tagName.equals(childItem.getNodeName())) && !tagName.equals(childItem.getLocalName())) continue;
            elementList.add((Element)childItem);
        }
        return elementList;
    }

    public static Element getFirstChildElement(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int ii = 0; ii < children.getLength(); ++ii) {
            if (children.item(ii).getNodeType() != 1) continue;
            return (Element)children.item(ii);
        }
        return null;
    }

    public static String elementToString(Element element) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(element), new StreamResult(sw));
            return sw.toString();
        }
        catch (RuntimeException | TransformerException e) {
            return "";
        }
    }

    public static Element getElement(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        Document document = XmlUtils.getDocument(reader);
        return document.getDocumentElement();
    }

    public static Element getFirstChildElementByName(String tagName, Element parent) {
        NodeList children = parent.getChildNodes();
        for (int ii = 0; ii < children.getLength(); ++ii) {
            if (children.item(ii).getNodeType() != 1 || !tagName.equals(children.item(ii).getNodeName())) continue;
            return (Element)children.item(ii);
        }
        return null;
    }

    public static Document documentFromString(String str) {
        try {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            return XmlUtils.getDocument(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Document getDocument(InputStream xmlCode) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.getDocument(new InputStreamReader(xmlCode));
    }

    public static Document getDocument(InputStream xmlCode, String encoding) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.getDocument(new InputStreamReader(xmlCode, Charset.forName(encoding)));
    }

    public static Document getDocument(Reader xmlCode) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new DefaultHandler());
        Document document = builder.parse(new InputSource(xmlCode));
        return document;
    }

    public static String documentToString(Document doc) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", true);
            return writer.writeToString(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFullTextFromChildren(Element element) {
        if (element == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1000);
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static Element getElementByTagNameNS(Element root, QName qname) {
        if (root == null) {
            return null;
        }
        NodeList nl = root.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public static Element getElementByTagNameNS(Element root, String namespaceURI, String localName) {
        if (root == null) {
            return null;
        }
        NodeList nl = root.getElementsByTagNameNS(namespaceURI, localName);
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public static void writeXmlDocument(Document document, File file) {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

