/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.cli;

import com.ericsson.lwac.utilities.cli.Flag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommandLine {
    private final String arguments;
    private final String[] commandLine;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<String> validProperties;
    private final List<Flag> flags = new LinkedList<Flag>();
    private String[] remaingArguments;
    private final Pattern propertyPattern = Pattern.compile("--(\\S+)=([\\S ]+)");

    private CommandLine(String arguments, Set<String> properties, String[] commandLine) {
        this.arguments = arguments;
        this.commandLine = commandLine;
        this.validProperties = properties;
    }

    public static CommandLine getCommandLine(String arguments, Set<String> properties, String[] commandLine) throws IllegalArgumentException {
        CommandLine cli = new CommandLine(arguments, properties, commandLine);
        cli.process();
        return cli;
    }

    private void process() throws IllegalArgumentException {
        int offset;
        for (int i = 0; i < this.commandLine.length; ++i) {
            this.commandLine[i] = this.commandLine[i].replaceAll("^'?(.*?)'?$", "$1");
        }
        for (offset = 0; offset < this.commandLine.length && this.commandLine[offset].startsWith("-") && this.commandLine[offset].length() > 1; ++offset) {
            if (this.commandLine[offset].startsWith("--")) {
                Matcher matcher = this.propertyPattern.matcher(this.commandLine[offset]);
                if (matcher.matches()) {
                    String name = matcher.group(1);
                    String value = matcher.group(2);
                    if (!this.validProperties.contains(name)) {
                        throw new IllegalArgumentException("Invalid property: " + this.commandLine[offset]);
                    }
                    this.properties.put(name, value);
                    continue;
                }
                if (!this.commandLine[offset].contains("=")) {
                    throw new IllegalArgumentException("Property missing =value: " + this.commandLine[offset]);
                }
                throw new IllegalArgumentException("Unrecognized property: " + this.commandLine[offset]);
            }
            String currentArgument = null;
            String current = this.commandLine[offset].substring(1, 2);
            int idx = this.arguments.indexOf(current);
            if (idx == -1) {
                throw new IllegalArgumentException("Unrecognized argument: -" + current);
            }
            if (idx + 1 < this.arguments.length() && ":".equals(this.arguments.substring(idx + 1, idx + 2))) {
                if (offset + 1 == this.commandLine.length || this.commandLine[++offset].startsWith("-")) {
                    throw new IllegalArgumentException("Missing argument: -" + current + " ??");
                }
                currentArgument = this.commandLine[offset];
            }
            char mCurrent = current.toCharArray()[0];
            this.flags.add(new Flag(mCurrent, currentArgument));
        }
        this.remaingArguments = new String[this.commandLine.length - offset];
        if (this.remaingArguments.length > 0) {
            System.arraycopy(this.commandLine, offset, this.remaingArguments, 0, this.remaingArguments.length);
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Flag> getFlags() {
        return this.flags;
    }

    public String[] getRemaingArguments() {
        return Arrays.copyOf(this.remaingArguments, this.remaingArguments.length);
    }
}

