/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.csv;

import com.ericsson.lwac.utilities.csv.CSVCodecAdaptor;
import com.ericsson.lwac.utilities.csv.CSVCodecAdaptorInfo;
import com.ericsson.lwac.utilities.csv.CSVCodecException;
import com.ericsson.lwac.utilities.csv.CSVCodecHeaderInfo;
import com.ericsson.lwac.utilities.csv.CSVCodecInfo;
import com.ericsson.lwac.utilities.csv.CSVElement;
import com.ericsson.lwac.utilities.csv.CSVStreamParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CSVCodec {
    private static final String LINEFEED = "\n";
    private static final String StartDateTimeEndDateTime = "startDateTime;endDateTime;";
    private static final String DateTime = "reportDate;";
    private final char delimiter;
    private final Map<Class<?>, CSVAdaptorWrapper<?>> regiteredAdaptors = new HashMap();
    private static final char QUOTE_DOUBLE = '\"';

    public CSVCodec(char delimiter) {
        this.delimiter = delimiter;
    }

    public <T> void registerAdaptor(Class<T> cls, CSVCodecAdaptor<T> codec) {
        this.regiteredAdaptors.put(cls, new CSVAdaptorWrapper<T>(cls, codec));
    }

    public void addCSVHeader(CSVCodecInfo csvInfo, OutputStream os) throws CSVCodecException {
        try {
            if (csvInfo.isAddheader()) {
                os.write(this.encodeCSVHeader(csvInfo).getBytes());
            }
        }
        catch (IOException e) {
            throw new CSVCodecException(String.format("Failed encode to CSV Reason: %s", e.getLocalizedMessage()), e);
        }
    }

    public <T> List<T> decode(Class<T> cls, File csvFile) throws CSVCodecException {
        CSVCodecInfo cvsInfo = CSVCodecInfo.create(cls);
        LinkedList<T> listOfT = new LinkedList<T>();
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(csvFile));
            CSVStreamParser parser = new CSVStreamParser(reader, this.delimiter, CSVCodecInfo.create(cls));
            if (cvsInfo.isAddheader()) {
                parser.next();
            }
            while (parser.hasNext()) {
                listOfT.add(this.decode(cls, parser.next()));
            }
        }
        catch (FileNotFoundException e) {
            throw new CSVCodecException(String.format("File not found: %s", csvFile), e);
        }
        return listOfT;
    }

    public <T> List<T> decode(Class<T> cls, InputStream csvFile) throws CSVCodecException {
        LinkedList<T> linkedList;
        CSVCodecInfo cvsInfo = CSVCodecInfo.create(cls);
        LinkedList<T> listOfT = new LinkedList<T>();
        int rowCounter = 0;
        InputStreamReader reader = new InputStreamReader(csvFile);
        try {
            CSVStreamParser parser = new CSVStreamParser(reader, this.delimiter, cvsInfo);
            if (cvsInfo.isAddheader()) {
                ++rowCounter;
                parser.next();
            }
            while (parser.hasNext()) {
                ++rowCounter;
                listOfT.add(this.decode(cls, parser.next()));
            }
            linkedList = listOfT;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CSVCodecException("Error occurred while reading at line: " + rowCounter, e);
            }
        }
        reader.close();
        return linkedList;
    }

    public <T> T decode(Class<T> cls, CSVElement csvRow) throws CSVCodecException {
        try {
            T obj = cls.newInstance();
            for (Map.Entry<Field, String> entry : csvRow.entrySet()) {
                boolean setUnAccessable = false;
                Field field = entry.getKey();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                    setUnAccessable = true;
                }
                if (field.isAnnotationPresent(CSVCodecAdaptorInfo.class)) {
                    CSVCodecAdaptorInfo adaptorClass = field.getAnnotation(CSVCodecAdaptorInfo.class);
                    CSVCodecAdaptor<? extends Object> adaptor = adaptorClass.value().newInstance();
                    field.set(obj, adaptor.decode(entry.getValue()));
                } else if (this.regiteredAdaptors.containsKey(field.getType())) {
                    field.set(obj, this.regiteredAdaptors.get(field.getType()).decode(entry.getValue()));
                } else {
                    throw new CSVCodecException(String.format("Unsupported type: %s", field.getType().getSimpleName()));
                }
                if (!setUnAccessable) continue;
                field.setAccessible(false);
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CSVCodecException(String.format("Failed encode to CSV Reason: %s", e.getLocalizedMessage()), e);
        }
    }

    public <T> void encode(List<T> objectList, CSVCodecInfo csvInfo, OutputStream os) throws CSVCodecException {
        if (objectList.isEmpty()) {
            return;
        }
        try {
            for (T obj : objectList) {
                os.write(this.encodeObject(obj, csvInfo).getBytes());
            }
        }
        catch (IOException e) {
            throw new CSVCodecException(String.format("Failed encode to CSV Reason: %s", e.getLocalizedMessage()), e);
        }
    }

    public <T> void encode(T obj, CSVCodecInfo csvInfo, OutputStream os) throws CSVCodecException {
        if (obj == null) {
            return;
        }
        try {
            os.write(this.encodeObject(obj, csvInfo).getBytes());
        }
        catch (IOException e) {
            throw new CSVCodecException(String.format("Failed encode to CSV Reason: %s", e.getLocalizedMessage()), e);
        }
    }

    private <T> String encodeObject(T obj, CSVCodecInfo csvInfo) throws CSVCodecException {
        if (obj == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1048);
        Field lastField = csvInfo.getCsvfieldorder().get(csvInfo.getCsvfieldorder().size() - 1);
        for (Field field : csvInfo.getCsvfieldorder()) {
            boolean isLastField = field.equals(lastField);
            boolean setUnAccessable = false;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                    setUnAccessable = true;
                }
                if (csvInfo.isUseQuotation()) {
                    sb.append('\"');
                }
                if (field.isAnnotationPresent(CSVCodecAdaptorInfo.class)) {
                    CSVCodecAdaptorInfo adaptorClass = field.getAnnotation(CSVCodecAdaptorInfo.class);
                    CSVCodecAdaptor<? extends Object> adaptor = adaptorClass.value().newInstance();
                    sb.append(adaptor.encode(field.get(obj)));
                } else if (this.regiteredAdaptors.containsKey(field.getType())) {
                    sb.append(this.regiteredAdaptors.get(field.getType()).encode(field.get(obj)));
                } else {
                    Object value = field.get(obj);
                    sb.append(value != null ? value.toString() : "");
                }
                if (csvInfo.isUseQuotation()) {
                    sb.append('\"');
                }
                this.appendDelimiter(sb, this.delimiter, isLastField, csvInfo.isUseDelimeterAtEndOfRow());
                if (!setUnAccessable) continue;
                field.setAccessible(false);
            }
            catch (Exception e) {
                throw new CSVCodecException(String.format("Failed encode to CSV Reason: %s", e.getLocalizedMessage()), e);
            }
        }
        if (csvInfo.isAddlinefeed()) {
            sb.append(LINEFEED);
        }
        return sb.toString();
    }

    private void appendDelimiter(StringBuilder sb, char delimiter2, boolean isLastField, boolean useDelimeterAtEndOfRow) {
        if (isLastField) {
            if (useDelimeterAtEndOfRow) {
                sb.append(delimiter2);
            }
        } else {
            sb.append(delimiter2);
        }
    }

    private String encodeCSVHeader(CSVCodecInfo csvInfo) {
        StringBuilder sb = new StringBuilder(1048);
        if (csvInfo.isAddDateTime()) {
            if (csvInfo.isUseSingleDate()) {
                sb.append(DateTime);
            } else {
                sb.append(StartDateTimeEndDateTime);
            }
        }
        for (Field field : csvInfo.getCsvfieldorder()) {
            if (field.isAnnotationPresent(CSVCodecHeaderInfo.class)) {
                CSVCodecHeaderInfo headerInfo = field.getAnnotation(CSVCodecHeaderInfo.class);
                sb.append(headerInfo.name()).append(this.delimiter);
                continue;
            }
            sb.append(field.getName()).append(this.delimiter);
        }
        sb.append(LINEFEED);
        return sb.toString();
    }

    private static class CSVAdaptorWrapper<T> {
        final Class<T> classOfT;
        final CSVCodecAdaptor<T> adaptor;

        CSVAdaptorWrapper(Class<T> classOfT, CSVCodecAdaptor<T> adaptor) {
            this.classOfT = classOfT;
            this.adaptor = adaptor;
        }

        T decode(String data) throws CSVCodecException {
            return this.adaptor.decode(data);
        }

        String encode(Object data) throws CSVCodecException {
            return this.adaptor.encode(this.classOfT.cast(data));
        }
    }
}

