/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.csv;

import com.ericsson.lwac.utilities.csv.CSVCodecException;
import com.ericsson.lwac.utilities.csv.CSVFieldOrder;
import com.ericsson.lwac.utilities.csv.CSVInfo;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CSVCodecInfo {
    private final Class<?> type;
    private final String name;
    private final String filename;
    private final CSVFieldOrder csvfieldorder;
    private final boolean addheader;
    private final boolean addlinefeed;
    private final List<Integer> ignoreIndex;
    private final boolean addDateTime;
    private final boolean usesingledate;
    private final boolean useQuotation;
    private final boolean useDelimeterAtEndOfRow;

    public static <T> CSVCodecInfo create(Class<T> cls) throws CSVCodecException {
        if (cls.isAnnotationPresent(CSVInfo.class)) {
            CSVInfo annotation;
            CSVInfo csvInfo = annotation = cls.getAnnotation(CSVInfo.class);
            LinkedList<Integer> tmp = new LinkedList<Integer>();
            for (String index : csvInfo.ignoreindex()) {
                tmp.add(Integer.parseInt(index));
            }
            return new CSVCodecInfo(cls, csvInfo.name(), csvInfo.filename(), CSVFieldOrder.create(cls, csvInfo.csvfieldorder()), csvInfo.addheader(), csvInfo.addlinefeed(), tmp, csvInfo.adddatetime(), csvInfo.usesingledate(), csvInfo.usequotation(), csvInfo.usedelimeteratendofrow());
        }
        throw new CSVCodecException(String.format("Class %s is missing the %s annotation", cls.getSimpleName(), CSVInfo.class.getSimpleName()));
    }

    private CSVCodecInfo(Class<?> type, String name, String filename, CSVFieldOrder csvfieldorder, boolean addheader, boolean addlinefeed, List<Integer> ignoreIndex, boolean addDateTime, boolean usesingledate, boolean useQuotation, boolean useDelimeterAtEndOfRow) {
        this.type = type;
        this.name = name;
        this.filename = filename;
        this.csvfieldorder = csvfieldorder;
        this.addheader = addheader;
        this.addlinefeed = addlinefeed;
        this.ignoreIndex = Collections.unmodifiableList(ignoreIndex);
        this.usesingledate = usesingledate;
        this.addDateTime = addDateTime;
        this.useQuotation = useQuotation;
        this.useDelimeterAtEndOfRow = useDelimeterAtEndOfRow;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<Field> getCsvfieldorder() {
        return this.csvfieldorder.get();
    }

    public List<Integer> getIgnoreIndex() {
        return this.ignoreIndex;
    }

    public boolean isAddheader() {
        return this.addheader;
    }

    public boolean isAddlinefeed() {
        return this.addlinefeed;
    }

    public boolean isUseSingleDate() {
        return this.usesingledate;
    }

    public boolean isAddDateTime() {
        return this.addDateTime;
    }

    public boolean isUseQuotation() {
        return this.useQuotation;
    }

    public boolean isUseDelimeterAtEndOfRow() {
        return this.useDelimeterAtEndOfRow;
    }
}

