/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.csv;

import com.ericsson.lwac.utilities.csv.CSVCodecInfo;
import com.ericsson.lwac.utilities.csv.CSVElement;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVStreamParser
implements Iterator<CSVElement> {
    private static final char QUOTE_SINGLE = '\'';
    private static final char QUOTE_DOUBLE = '\"';
    private final LineNumberReader lineNumberReader;
    private final Character delimiter;
    private volatile String nextInLine;
    private static final Logger logger = LoggerFactory.getLogger(CSVStreamParser.class);
    private final List<Field> csvFieldOrder;
    private final List<Integer> ignoreIndex;

    public CSVStreamParser(InputStreamReader is, char delim, CSVCodecInfo csvInfo) {
        this.lineNumberReader = new LineNumberReader(is);
        this.delimiter = Character.valueOf(delim);
        this.csvFieldOrder = new CircularArrayList<Field>(csvInfo.getCsvfieldorder());
        this.ignoreIndex = csvInfo.getIgnoreIndex();
    }

    @Override
    public boolean hasNext() {
        if (this.nextInLine == null) {
            try {
                this.nextInLine = this.lineNumberReader.readLine();
                if (this.nextInLine != null) {
                    this.nextInLine = this.nextInLine.trim();
                    while (this.nextInLine.length() < 5 || !this.nextInLine.contains(this.delimiter.toString())) {
                        this.nextInLine = this.lineNumberReader.readLine();
                        if (this.nextInLine != null) {
                            this.nextInLine = this.nextInLine.trim();
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException e) {
                logger.warn("Internal Error: CSVStreamParser failed to read line, Reason " + e.getLocalizedMessage());
            }
            return false;
        }
        return true;
    }

    @Override
    public CSVElement next() throws NoSuchElementException {
        if (this.nextInLine == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.parseLine(this.nextInLine);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public CSVElement parseLine(String line) {
        CSVElement elem = new CSVElement();
        boolean insideAQuote = false;
        int currenctCharIndex = 0;
        int currenctCollumnIndex = 0;
        char quoteChar = ' ';
        Object field = "";
        ((CircularArrayList)this.csvFieldOrder).reset();
        try {
            for (char c : line.toCharArray()) {
                ++currenctCharIndex;
                if (c == this.delimiter.charValue()) {
                    if (insideAQuote) {
                        field = (String)field + (char)c;
                        continue;
                    }
                    if (!this.ignoreIndex.contains(currenctCollumnIndex++)) {
                        elem.add((Field)((CircularArrayList)this.csvFieldOrder).next(), (String)field);
                    }
                    field = "";
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    if (insideAQuote) {
                        if (c == quoteChar && currenctCharIndex == line.length()) {
                            insideAQuote = false;
                            quoteChar = ' ';
                            continue;
                        }
                        field = (String)field + (char)c;
                        continue;
                    }
                    if (((String)field).length() == 0) {
                        insideAQuote = true;
                        quoteChar = c;
                        continue;
                    }
                    field = (String)field + (char)c;
                    continue;
                }
                field = (String)field + (char)c;
            }
            if (((String)field).length() > 1) {
                elem.add((Field)((CircularArrayList)this.csvFieldOrder).next(), (String)field);
            }
        }
        catch (NullPointerException e) {
            this.nextInLine = null;
            return null;
        }
        this.nextInLine = null;
        return elem;
    }

    private static class CircularArrayList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private volatile int index = -1;

        public CircularArrayList(Collection<? extends E> c) {
            super(c);
        }

        public void reset() {
            this.index = -1;
        }

        public E next() {
            if (this.index >= this.size() - 1) {
                this.index = 0;
            }
            return super.get(++this.index);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

