/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.functional.typed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

@FunctionalInterface
public interface CheckedSupplier<T, E extends Exception> {
    public T get() throws E;

    public static <T> Supplier<T> toUnchecked(CheckedSupplier<T, Exception> supplier) {
        Preconditions.checkNotNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

