/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import com.ericsson.utils.FileSizeUnit;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileSize
implements Comparable<FileSize> {
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)", 2);
    private final long size;
    private final FileSizeUnit fileSizeUnit;

    public FileSize(long size, FileSizeUnit fileSizeUnit) {
        this.size = size;
        this.fileSizeUnit = fileSizeUnit;
    }

    public long getSize() {
        return this.size;
    }

    public FileSizeUnit getFileSizeUnit() {
        return this.fileSizeUnit;
    }

    public long getSize(FileSizeUnit unit) {
        return unit.convert(this.size, this.fileSizeUnit);
    }

    public String toString() {
        long sizeInBytes = FileSizeUnit.BYTES.convert(this.size, this.fileSizeUnit);
        FileSizeUnit[] units = FileSizeUnit.values();
        for (int i = units.length - 1; i >= 0; --i) {
            if (!((double)sizeInBytes / Math.pow(1024.0, i) >= 10.0)) continue;
            return units[i].toString((long)((double)sizeInBytes / Math.pow(1024.0, i) * 100.0) / 100L);
        }
        return "-";
    }

    @Override
    public int compareTo(FileSize o) {
        return Long.compare(this.getSize(FileSizeUnit.BYTES), o.getSize(FileSizeUnit.BYTES));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSize fileSize = (FileSize)o;
        return this.getSize(FileSizeUnit.BYTES) == fileSize.getSize(FileSizeUnit.BYTES);
    }

    public int hashCode() {
        return Objects.hash(this.getSize(FileSizeUnit.BYTES));
    }

    public static FileSize valueOf(String fileSizeStr) {
        Matcher matcher = FILE_SIZE_PATTERN.matcher(fileSizeStr);
        if (matcher.matches()) {
            int size = Integer.parseInt(matcher.group(1));
            FileSizeUnit fileSizeUnit = FileSizeUnit.valueOfAbbreviation(matcher.group(2));
            return new FileSize(size, fileSizeUnit);
        }
        throw new IllegalArgumentException(String.format("Could not match file size (%s)", fileSizeStr));
    }
}

