/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import com.ericsson.utils.ObjectCreateException;
import com.ericsson.utils.ObjectDestroyException;
import com.ericsson.utils.ObjectFactory;
import com.ericsson.utils.designbycontract.Preconditions;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectPool<T> {
    private static final Logger mLogger = LoggerFactory.getLogger(ObjectPool.class);
    private final ObjectFactory<T> mObjectFactory;
    private final BlockingQueue<T> mPool = new LinkedBlockingQueue<T>();
    private final Set<T> mSustainedPool = new CopyOnWriteArraySet<T>();
    private Semaphore mTemporaryCounter;
    private final int mInitialSize;
    private int mSustainedSize = 0;
    private int mMaxSize = 0;
    private int mMaxWaitTime = 1000;
    private final ReadWriteLock mModificationLock = new ReentrantReadWriteLock();

    public ObjectPool(ObjectFactory<T> objectFactory, int initialSize, int sustainedSize, int maxSize) throws ObjectCreateException {
        this.mObjectFactory = objectFactory;
        this.mMaxSize = maxSize;
        this.mSustainedSize = sustainedSize;
        this.mInitialSize = initialSize;
        this.init();
    }

    private void init() throws ObjectCreateException {
        this.setMaxSize(this.mMaxSize);
        this.setSustainedSize(this.mSustainedSize);
        for (int i = 0; i < this.mInitialSize; ++i) {
            T object = this.mObjectFactory.create();
            this.mPool.add(object);
            this.mSustainedPool.add(object);
        }
    }

    public T poll() {
        return this.poll(this.mMaxWaitTime, TimeUnit.MILLISECONDS);
    }

    public T poll(ProgressListener progressListener) {
        return this.poll(this.mMaxWaitTime, TimeUnit.MILLISECONDS, progressListener);
    }

    public T poll(int timeOut, TimeUnit timeUnit) {
        return this.poll(timeOut, timeUnit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(int timeOut, TimeUnit timeUnit, ProgressListener progressListener) {
        try {
            this.mModificationLock.readLock().lock();
            Object object = this.mPool.poll();
            if (object == null) {
                block22: {
                    try {
                        if (this.mSustainedPool.size() >= this.mSustainedSize) break block22;
                        this.mModificationLock.readLock().unlock();
                        this.mModificationLock.writeLock().lock();
                        try {
                            if (this.mSustainedPool.size() < this.mSustainedSize) {
                                object = this.mObjectFactory.create();
                                this.mSustainedPool.add(object);
                            }
                        }
                        finally {
                            this.mModificationLock.readLock().lock();
                            this.mModificationLock.writeLock().unlock();
                        }
                    }
                    catch (Exception e) {
                        mLogger.error("Error while creating pooled object, {}", (Object)e.toString());
                        mLogger.debug(e.getMessage(), e);
                        T t = null;
                        this.mModificationLock.readLock().unlock();
                        return t;
                    }
                }
                if (object == null) {
                    try {
                        boolean create = false;
                        if (this.mTemporaryCounter.tryAcquire()) {
                            if (progressListener != null) {
                                progressListener.onSustainedNotAvailable();
                            }
                            create = true;
                        } else if (this.mTemporaryCounter.tryAcquire(timeOut, timeUnit)) {
                            if (progressListener != null) {
                                progressListener.onMaximumReached();
                            }
                            create = true;
                        }
                        if (create) {
                            try {
                                object = this.mObjectFactory.create();
                            }
                            catch (Exception e) {
                                mLogger.error("Error while creating pooled object, {}", (Object)e.toString());
                                mLogger.debug(e.getMessage(), e);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Object e = object;
            return (T)e;
        }
        finally {
            this.mModificationLock.readLock().unlock();
        }
    }

    public T take() throws InterruptedException {
        T object;
        try {
            this.mModificationLock.readLock().lock();
            object = this.mPool.take();
        }
        finally {
            this.mModificationLock.readLock().unlock();
        }
        return object;
    }

    public void returnObject(T object) {
        try {
            this.mModificationLock.readLock().lock();
            if (this.mSustainedPool.contains(object)) {
                this.mPool.add(object);
            } else {
                try {
                    this.mObjectFactory.destroy(object);
                    this.mTemporaryCounter.release();
                }
                catch (Exception ex) {
                    mLogger.error("Error while destroying pooled object, {}", (Object)ex.toString());
                    mLogger.debug(ex.getMessage(), ex);
                }
            }
        }
        finally {
            this.mModificationLock.readLock().unlock();
        }
    }

    public void returnObject(T object, boolean failed) {
        Preconditions.assertNotNull(object);
        if (failed) {
            if (this.mSustainedPool.contains(object)) {
                try {
                    this.mModificationLock.writeLock().lock();
                    this.mSustainedPool.remove(object);
                }
                finally {
                    this.mModificationLock.writeLock().unlock();
                }
            } else {
                this.mTemporaryCounter.release();
            }
        } else {
            this.returnObject(object);
        }
    }

    public int getAvailableSustained() {
        return this.mPool.size();
    }

    public int getAvailbleTemporary() {
        return this.mTemporaryCounter.availablePermits();
    }

    public int getMaxWaitTime() {
        return this.mMaxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.mMaxWaitTime = maxWaitTime;
    }

    public int getSustainedSize() {
        return this.mSustainedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSustainedSize(int sustainedSize) {
        try {
            this.mModificationLock.writeLock().lock();
            if (this.mMaxSize < sustainedSize) {
                throw new IllegalArgumentException(String.format("Pool sustained size can not be larger than max size (%d < %d)", this.mMaxSize, this.mSustainedSize));
            }
            if (this.mSustainedSize > sustainedSize) {
                for (int i = this.mSustainedSize; i > sustainedSize; --i) {
                    Object object = this.mPool.poll();
                    this.mSustainedPool.remove(object);
                    try {
                        this.mObjectFactory.destroy(object);
                        continue;
                    }
                    catch (Exception ex) {
                        mLogger.error("Error while creating pooled object, {}", (Object)ex.toString());
                        mLogger.debug(ex.getMessage(), ex);
                    }
                }
            }
            this.mSustainedSize = sustainedSize;
            this.mTemporaryCounter = new Semaphore(this.mMaxSize - this.mSustainedSize);
        }
        finally {
            this.mModificationLock.writeLock().unlock();
        }
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public void setMaxSize(int maxSize) {
        try {
            this.mModificationLock.writeLock().lock();
            if (maxSize < this.mSustainedSize) {
                throw new IllegalArgumentException(String.format("Pool max size can not be less than sustained size (%d < %d)", this.mMaxSize, this.mSustainedSize));
            }
            this.mMaxSize = maxSize;
            this.mTemporaryCounter = new Semaphore(this.mMaxSize - this.mSustainedSize);
        }
        finally {
            this.mModificationLock.writeLock().unlock();
        }
    }

    public void recreate() throws ObjectCreateException, ObjectDestroyException {
        try {
            this.mModificationLock.writeLock().lock();
            this.destroy0();
            this.init();
        }
        finally {
            this.mModificationLock.writeLock().unlock();
        }
    }

    public void destroy() throws Exception {
        try {
            this.mModificationLock.writeLock().lock();
            this.destroy0();
        }
        finally {
            this.mModificationLock.writeLock().unlock();
        }
    }

    private void destroy0() throws ObjectDestroyException {
        for (T object : this.mSustainedPool) {
            this.mObjectFactory.destroy(object);
        }
        this.mPool.clear();
        this.mSustainedPool.clear();
    }

    public static interface ProgressListener {
        public void onSustainedNotAvailable();

        public void onMaximumReached();
    }
}

