/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private static final String REVISION_PATTERN = "(?:(\\d+)\\.?)+?(?:-(?:(rc|alpha|dev)(\\d+))?)?";
    private static final Pattern revisionPattern = Pattern.compile("(?:(\\d+)\\.?)+?(?:-(?:(rc|alpha|dev)(\\d+))?)?");

    @Override
    public int compare(String o1, String o2) {
        Integer[][] revision1Components = VersionComparator.getComponents(o1);
        Integer[][] revision2Components = VersionComparator.getComponents(o2);
        for (int mainComponent = 0; mainComponent < 2; ++mainComponent) {
            for (int i = 0; i < revision1Components[mainComponent].length || i < revision2Components[mainComponent].length; ++i) {
                int revisionComponent2;
                int revisionComponent1 = i < revision1Components[mainComponent].length ? revision1Components[mainComponent][i] : 0;
                int compare = revisionComponent1 - (revisionComponent2 = i < revision2Components[mainComponent].length ? revision2Components[mainComponent][i] : 0);
                if (compare == 0) continue;
                return compare;
            }
        }
        return 0;
    }

    static Integer[][] getComponents(String revision) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        LinkedList<Integer> devVersion = new LinkedList<Integer>();
        boolean processingDev = false;
        Matcher matcher = revisionPattern.matcher(revision);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Could not match revision %s with %s", revision, REVISION_PATTERN));
        }
        matcher.reset();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int value;
                String group = matcher.group(i);
                if (group == null) continue;
                switch (group) {
                    case "dev": {
                        value = -4;
                        processingDev = true;
                        break;
                    }
                    case "alpha": {
                        value = -2;
                        processingDev = true;
                        break;
                    }
                    case "rc": {
                        value = -1;
                        processingDev = true;
                        break;
                    }
                    default: {
                        value = Integer.parseInt(group);
                    }
                }
                if (processingDev) {
                    devVersion.add(value);
                    continue;
                }
                result.add(value);
            }
        }
        if (revision.endsWith("-SNAPSHOT")) {
            devVersion.add(-1);
        }
        return new Integer[][]{result.toArray(new Integer[result.size()]), devVersion.toArray(new Integer[devVersion.size()])};
    }
}

