/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.cli;

import com.ericsson.utils.cli.Flag;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommandLine {
    private final String mArguments;
    private final String[] mCommandLine;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final Set<String> mValidProperties;
    private final List<Flag> mFlags = new LinkedList<Flag>();
    private char mCurrent;
    private String[] mRemaingArguments;
    private final Pattern mPropertyPattern = Pattern.compile("--(\\S+)=([\\S ]+)");

    private CommandLine(String arguments, Set<String> properties, String[] commandLine) {
        this.mArguments = arguments;
        this.mCommandLine = commandLine;
        this.mValidProperties = properties;
    }

    public static CommandLine getCommandLine(String arguments, Set<String> properties, String[] commandLine) throws IllegalArgumentException {
        CommandLine cli = new CommandLine(arguments, properties, commandLine);
        cli.process();
        return cli;
    }

    private void process() throws IllegalArgumentException {
        int offset;
        for (offset = 0; offset < this.mCommandLine.length && this.mCommandLine[offset].startsWith("-") && this.mCommandLine[offset].length() > 1; ++offset) {
            if (this.mCommandLine[offset].startsWith("--")) {
                Matcher matcher = this.mPropertyPattern.matcher(this.mCommandLine[offset]);
                if (matcher.matches()) {
                    String name = matcher.group(1);
                    String value = matcher.group(2);
                    if (!this.mValidProperties.contains(name)) {
                        throw new IllegalArgumentException("Invalid property: " + this.mCommandLine[offset]);
                    }
                    this.mProperties.put(name, value);
                    continue;
                }
                if (!this.mCommandLine[offset].contains("=")) {
                    throw new IllegalArgumentException("Property missing =value: " + this.mCommandLine[offset]);
                }
                throw new IllegalArgumentException("Unrecognized property: " + this.mCommandLine[offset]);
            }
            String currentArgument = null;
            String current = this.mCommandLine[offset].substring(1, 2);
            int idx = this.mArguments.indexOf(current);
            if (idx == -1) {
                throw new IllegalArgumentException("Unrecognized argument: -" + current);
            }
            if (idx + 1 < this.mArguments.length() && ":".equals(this.mArguments.substring(idx + 1, idx + 2))) {
                if (offset + 1 == this.mCommandLine.length || this.mCommandLine[++offset].startsWith("-")) {
                    throw new IllegalArgumentException("Missing argument: -" + current + " ??");
                }
                currentArgument = this.mCommandLine[offset];
            }
            this.mCurrent = current.toCharArray()[0];
            this.mFlags.add(new Flag(this.mCurrent, currentArgument));
        }
        this.mRemaingArguments = new String[this.mCommandLine.length - offset];
        if (this.mRemaingArguments.length > 0) {
            System.arraycopy(this.mCommandLine, offset, this.mRemaingArguments, 0, this.mRemaingArguments.length);
        }
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public List<Flag> getFlags() {
        return this.mFlags;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getRemaingArguments() {
        return this.mRemaingArguments;
    }
}

