/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.table;

import com.ericsson.utils.table.CLIHeader;
import com.ericsson.utils.table.CLITuple;

public class CLIHeaders
extends CLITuple {
    private final CLIHeader[] header;

    public CLIHeaders(CLIHeader[] headers) {
        this.header = (CLIHeader[])headers.clone();
    }

    public CLIHeaders(CLIHeader header) {
        this.header = new CLIHeader[1];
        this.header[0] = header;
    }

    public CLIHeaders(String ... headers) {
        this.header = new CLIHeader[headers.length];
        for (int i = 0; i < this.header.length; ++i) {
            this.header[i] = new CLIHeader(headers[i], 1);
        }
    }

    public int getNumOfColumns() {
        return this.header.length;
    }

    @Override
    String toString(String indent, int[] spacings, String separator) {
        StringBuilder builder = new StringBuilder();
        int length = this.getColumns();
        builder.append(this.horizontalSeparator(indent, this.header.length - 1, spacings)).append(System.lineSeparator());
        for (int i = 0; i < length; i += this.header[i].getSpan()) {
            CLIHeader entry = this.header[i];
            int actual = this.getActualSpacing(entry, spacings, i);
            builder.append(indent).append(entry.getName()).append(CLIHeaders.separator(actual, " ", separator));
        }
        builder.append(System.lineSeparator());
        builder.append(indent).append(this.horizontalSeparator(indent, this.header.length - 2, spacings)).append(System.lineSeparator());
        return builder.toString();
    }

    private String horizontalSeparator(String indent, int indentCount, int[] spacings) {
        StringBuilder builder = new StringBuilder();
        if (indent != null) {
            builder.append(CLIHeaders.separator(indent.length() * indentCount, "-", null));
        }
        for (int spacing : spacings) {
            builder.append(CLIHeaders.separator(spacing, "-", null));
        }
        return builder.toString();
    }

    private static String separator(int actual, String padding, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < actual; ++i) {
            builder.append(padding);
        }
        if (separator != null) {
            builder.append(separator).toString();
        }
        return builder.toString();
    }

    private int getActualSpacing(CLIHeader header, int[] spacings, int position) {
        int actual = 0;
        for (int i = position; i < position + header.getSpan(); ++i) {
            actual += spacings[position];
        }
        return actual - header.getName().length();
    }

    @Override
    int getWidth(int position) {
        int length = this.getColumns();
        for (int i = 0; i < length; i += this.header[i].getSpan()) {
            CLIHeader entry = this.header[i];
            if (position == i) {
                return entry.getName().length();
            }
            if (position >= i) continue;
            return 0;
        }
        return 0;
    }

    public int getColumns() {
        int length = 0;
        for (CLIHeader header : this.header) {
            length += header.getSpan();
        }
        return length;
    }
}

