/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.validation;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlClassPathAggregateResourceBundleLocator {
    private static final Logger log = LoggerFactory.getLogger(UrlClassPathAggregateResourceBundleLocator.class);
    private static final String BUNDLE_NAME = "ValidationMessages";
    public static final String HIBERNATE_VALIDATION_MESSAGES = "org.hibernate.validator.ValidationMessages";
    private final Map<String, URL> classPaths;

    public UrlClassPathAggregateResourceBundleLocator() {
        Map<String, URL> classPaths = UrlClassPathAggregateResourceBundleLocator.getValidationResources();
        LinkedHashMap<String, URL> tmpClassPaths = new LinkedHashMap<String, URL>();
        tmpClassPaths.putAll(classPaths);
        this.classPaths = Collections.unmodifiableMap(tmpClassPaths);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader aClassLoader;
        ArrayList<ResourceBundle> sourceBundles = new ArrayList<ResourceBundle>();
        ResourceBundle oneBundle = null;
        ResourceBundle defaultBundle = null;
        ClassLoader classLoader = GetClassLoader.fromContext().run();
        if (classLoader != null) {
            oneBundle = this.loadBundle(classLoader, locale, BUNDLE_NAME, " not found by thread local classloader");
            defaultBundle = this.loadBundle(classLoader, locale, HIBERNATE_VALIDATION_MESSAGES, " not found by thread local classloader");
        }
        if (oneBundle == null) {
            aClassLoader = GetClassLoader.fromClass(UrlClassPathAggregateResourceBundleLocator.class).run();
            oneBundle = this.loadBundle(aClassLoader, locale, BUNDLE_NAME, " not found by validator classloader");
            if (classLoader == null) {
                classLoader = aClassLoader;
            }
        }
        if (defaultBundle == null) {
            aClassLoader = GetClassLoader.fromClass(UrlClassPathAggregateResourceBundleLocator.class).run();
            defaultBundle = this.loadBundle(aClassLoader, locale, HIBERNATE_VALIDATION_MESSAGES, " not found by validator classloader");
            if (classLoader == null) {
                classLoader = aClassLoader;
            }
        }
        if (log.isDebugEnabled()) {
            if (oneBundle != null) {
                log.debug("ValidationMessages found in application classpath");
            } else {
                log.debug("ValidationMessages not found in application classpath.");
            }
        }
        if (oneBundle != null) {
            sourceBundles.add(oneBundle);
        }
        for (Map.Entry<String, URL> entry : this.classPaths.entrySet()) {
            URL url = entry.getValue();
            classLoader = GetClassLoader.fromURL(new URL[]{url}).run();
            oneBundle = this.loadBundle(classLoader, locale, BUNDLE_NAME, " not found by URL classloader (" + url.getFile() + ")");
            if (log.isDebugEnabled()) {
                if (oneBundle != null) {
                    log.debug("ValidationMessages found by URL classloader (" + url.getFile() + ")");
                } else {
                    log.debug("ValidationMessages not found by URL classloader (" + url.getFile() + ")");
                }
            }
            if (oneBundle == null) continue;
            sourceBundles.add(oneBundle);
        }
        if (log.isDebugEnabled()) {
            if (defaultBundle != null) {
                log.debug("org.hibernate.validator.ValidationMessages found in application classpath");
            } else {
                log.debug("org.hibernate.validator.ValidationMessages not found in application classpath.");
            }
        }
        if (defaultBundle != null) {
            sourceBundles.add(defaultBundle);
        }
        return sourceBundles.isEmpty() ? null : new UrlClassPathAggregateBundle(sourceBundles);
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String bundleName, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(BUNDLE_NAME + message);
        }
        return rb;
    }

    private static Map<String, URL> getValidationResources() {
        LinkedHashMap<String, URL> resourcePaths = new LinkedHashMap<String, URL>();
        ClassLoader classLoader = GetClassLoader.fromContext().run();
        if (classLoader == null) {
            classLoader = GetClassLoader.fromClass(UrlClassPathAggregateResourceBundleLocator.class).run();
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                String key = UrlClassPathAggregateResourceBundleLocator.createKey(url.getFile());
                if (resourcePaths.containsKey(key)) continue;
                resourcePaths.put(key, url);
            }
        }
        return resourcePaths;
    }

    private static String createKey(String filePath) {
        int cutIndex = filePath.lastIndexOf(File.separatorChar);
        int length = filePath.length();
        if (cutIndex < 0 || cutIndex + 1 == length) {
            return filePath;
        }
        return filePath.substring(cutIndex + 1, length);
    }

    public static final class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;
        private final URL[] urls;

        public static GetClassLoader fromContext() {
            return new GetClassLoader();
        }

        public static GetClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            return new GetClassLoader(clazz);
        }

        public static GetClassLoader fromURL(URL[] urls) {
            if (urls == null) {
                throw new IllegalArgumentException("URL is null");
            }
            return new GetClassLoader(urls);
        }

        private GetClassLoader() {
            this.clazz = null;
            this.urls = null;
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
            this.urls = null;
        }

        private GetClassLoader(URL[] urls) {
            this.clazz = null;
            this.urls = (URL[])urls.clone();
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            if (this.urls != null) {
                return new URLClassLoader(this.urls, null);
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }

    public static class UrlClassPathAggregateBundle
    extends ResourceBundle {
        private final Map<String, Object> contents = new HashMap<String, Object>();

        public UrlClassPathAggregateBundle(List<ResourceBundle> bundles) {
            if (bundles != null) {
                for (ResourceBundle bundle2 : bundles) {
                    Enumeration<String> keys = bundle2.getKeys();
                    while (keys.hasMoreElements()) {
                        String oneKey = keys.nextElement();
                        if (this.contents.containsKey(oneKey)) continue;
                        this.contents.put(oneKey, bundle2.getObject(oneKey));
                    }
                }
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            return new IteratorEnumeration<String>(this.contents.keySet().iterator());
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.contents.get(key);
        }

        public static class IteratorEnumeration<T>
        implements Enumeration<T> {
            private final Iterator<T> source;

            public IteratorEnumeration(Iterator<T> source) {
                if (source == null) {
                    throw new IllegalArgumentException("Source must not be null");
                }
                this.source = source;
            }

            @Override
            public boolean hasMoreElements() {
                return this.source.hasNext();
            }

            @Override
            public T nextElement() {
                return this.source.next();
            }
        }
    }
}

