/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.ere.util.Transformer;
import com.ericsson.vareditor.document.LimitingDocument;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.regex.Pattern;

public class ClassNameDocument
extends LimitingDocument {
    private static final Pattern JAVA_IDENTIFIER = Pattern.compile("^[a-zA-Z$_][a-zA-Z0-9$_.]*$");
    private static final Pattern JAVA_IDENTIFIER_OR_EMPTY = Pattern.compile("^|[a-zA-Z$_][a-zA-Z0-9$_.]*$");
    private static final Pattern JAVA_LETTER_OR_DIGIT = Pattern.compile("[a-zA-Z0-9$_.]");
    private ClassRules myRules;

    public ClassNameDocument(ClassRules rules) {
        super(JAVA_LETTER_OR_DIGIT, ClassNameDocument.createTextRegexp(rules));
        this.myRules = rules.clone();
    }

    private static Pattern createTextRegexp(ClassRules rules) {
        return rules.allowsEmptyName() ? JAVA_IDENTIFIER_OR_EMPTY : JAVA_IDENTIFIER;
    }

    @Override
    protected void testWholeText(String className) throws LimitingDocument.Rejection {
        super.testWholeText(className);
        if (!"".equals(className)) {
            try {
                Class<?> clazz = EreClassLoader.getClass(className);
                this.myRules.checkClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new LimitingDocument.Rejection("The name " + className + " does not refer to an existing class.");
            }
            catch (NoClassDefFoundError err) {
                throw new LimitingDocument.Rejection("The name " + className + " does not refer to an existing class.");
            }
        }
    }

    @Override
    protected void notifyListeners(String newText, String reason, boolean valid, boolean isStateChange) {
        super.notifyListeners(newText, reason, valid, true);
    }

    public static class ClassRules
    implements Cloneable {
        private static final String SUPERTYPE_ERROR = "%s must extend or implement %s.";
        private boolean myAllowEmptyName = true;
        private ConstructionChecker myConstructionChecker;
        private Class<?>[] mySuperTypes;
        private boolean myAllowAbstractClass;
        private Transformer<Class<?>, String> myClassChecker;

        private ClassRules() {
        }

        public ClassRules clone() {
            try {
                return (ClassRules)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public static ClassRules defaultRules() {
            return new ClassRules();
        }

        boolean allowsEmptyName() {
            return this.myAllowEmptyName;
        }

        void checkClass(Class<?> clazz) throws LimitingDocument.Rejection {
            this.checkModifiers(clazz);
            this.checkConstruction(clazz);
            this.checkSuperTypes(clazz);
            this.checkTransformer(clazz);
        }

        private void checkTransformer(Class<?> clazz) throws LimitingDocument.Rejection {
            String reason;
            if (this.myClassChecker != null && !StringUtil.isEmptyString(reason = this.myClassChecker.transform(clazz))) {
                throw new LimitingDocument.Rejection(reason);
            }
        }

        private void checkModifiers(Class<?> clazz) throws LimitingDocument.Rejection {
            int mod = clazz.getModifiers();
            if (Modifier.isAbstract(mod) && !this.myAllowAbstractClass) {
                throw new LimitingDocument.Rejection("The name " + clazz.getName() + " refers to an abstract class or an interface.");
            }
            if (!Modifier.isPublic(mod)) {
                throw new LimitingDocument.Rejection("The class " + clazz.getName() + " is not public.");
            }
        }

        private void checkSuperTypes(Class<?> clazz) throws LimitingDocument.Rejection {
            if (this.mySuperTypes != null) {
                for (Class<?> superType : this.mySuperTypes) {
                    if (superType.isAssignableFrom(clazz)) continue;
                    throw new LimitingDocument.Rejection(String.format(SUPERTYPE_ERROR, clazz.getName(), superType.getName()));
                }
            }
        }

        private void checkConstruction(Class<?> clazz) throws LimitingDocument.Rejection {
            if (this.myConstructionChecker != null) {
                this.myConstructionChecker.testConstruction(clazz);
            }
        }

        public ClassRules andRequireEmptyConstructor() {
            this.myConstructionChecker = new ConstructorChecker(new Class[0]);
            return this;
        }

        public ClassRules andRequireNonEmptyConstructor(Class<?> type, Class<?> ... moreTypes) {
            this.myConstructionChecker = new ConstructorChecker(this.joinArrays(new Class[]{type}, moreTypes));
            return this;
        }

        public ClassRules andRequireStaticConstruction(String methodName, Class<?> ... types) {
            this.myConstructionChecker = new ConstructionMethodChecker(methodName, Arrays.copyOf(types, types.length));
            return this;
        }

        public ClassRules andDisallowEmptyName() {
            this.myAllowEmptyName = false;
            return this;
        }

        public ClassRules andRequireSuperTypes(Class<?> type, Class<?> ... types) {
            Class<?>[] allTypes = this.joinArrays(new Class[]{type}, types);
            this.mySuperTypes = this.mySuperTypes != null ? this.joinArrays(this.mySuperTypes, allTypes) : allTypes;
            return this;
        }

        public ClassRules andUseCustomChecker(Transformer<Class<?>, String> classChecker) {
            this.myClassChecker = classChecker;
            return this;
        }

        public ClassRules andAllowAbstractClass() {
            this.myAllowAbstractClass = true;
            return this;
        }

        private Class<?>[] joinArrays(Class<?>[] array1, Class<?> ... array2) {
            int len = array1.length + array2.length;
            Class[] dest = new Class[len];
            System.arraycopy(array1, 0, dest, 0, array1.length);
            System.arraycopy(array2, 0, dest, array1.length, array2.length);
            return dest;
        }

        private static class ConstructionMethodChecker
        extends ConstructionChecker {
            private static final String MISSING_CONSTRUCTION_METHOD_ERROR = "Static construction method %s must be present.";
            private String myMethodName;
            private Class<?>[] myParameterTypes;

            ConstructionMethodChecker(String methodName, Class<?>[] paramTypes) {
                this.myMethodName = methodName;
                this.myParameterTypes = paramTypes;
            }

            @Override
            public void testConstructionImpl(Class<?> clazz) throws NoSuchMethodException, LimitingDocument.Rejection {
                Method method = clazz.getMethod(this.myMethodName, this.myParameterTypes);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new LimitingDocument.Rejection("Method " + method + " is not static.");
                }
            }

            @Override
            protected String createRejectionMessage(String message) {
                return String.format(MISSING_CONSTRUCTION_METHOD_ERROR, message);
            }
        }

        private static class ConstructorChecker
        extends ConstructionChecker {
            private static final String MISSING_CONSTRUCTOR_ERROR = "Constructor %s must be present.";
            private Class<?>[] myParameterTypes;

            ConstructorChecker(Class<?>[] paramTypes) {
                this.myParameterTypes = paramTypes;
            }

            @Override
            public void testConstructionImpl(Class<?> clazz) throws NoSuchMethodException, LimitingDocument.Rejection {
                clazz.getConstructor(this.myParameterTypes);
            }

            @Override
            protected String createRejectionMessage(String message) {
                return String.format(MISSING_CONSTRUCTOR_ERROR, message);
            }
        }

        private static abstract class ConstructionChecker {
            private ConstructionChecker() {
            }

            final void testConstruction(Class<?> clazz) throws LimitingDocument.Rejection {
                try {
                    this.testConstructionImpl(clazz);
                }
                catch (NoSuchMethodException ex) {
                    throw new LimitingDocument.Rejection(this.createRejectionMessage(ex.getMessage()));
                }
            }

            protected abstract String createRejectionMessage(String var1);

            protected abstract void testConstructionImpl(Class<?> var1) throws NoSuchMethodException, LimitingDocument.Rejection;
        }
    }
}

