/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.AbstractNumberDocument;
import com.ericsson.vareditor.document.LimitingDocument;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberDocument
extends AbstractNumberDocument {
    private BigDecimal myMin;
    private BigDecimal myMax;
    private boolean myAllowFloatingPoint;

    public NumberDocument(boolean allowFloatingPoint, boolean allowEmpty) {
        super(allowFloatingPoint, allowEmpty);
        this.myAllowFloatingPoint = allowFloatingPoint;
    }

    public NumberDocument(boolean allowEmpty, BigDecimal min, BigDecimal max) {
        this(true, allowEmpty);
        this.myMin = min;
        this.myMax = max;
    }

    public NumberDocument(boolean allowEmpty, BigInteger min, BigInteger max) {
        this(false, allowEmpty);
        this.myMin = new BigDecimal(min);
        this.myMax = new BigDecimal(max);
    }

    public NumberDocument(boolean allowEmpty, long min, long max) {
        this(allowEmpty, BigInteger.valueOf(min), BigInteger.valueOf(max));
    }

    public NumberDocument(boolean allowEmpty, double min, double max) {
        this(allowEmpty, BigDecimal.valueOf(min), BigDecimal.valueOf(max));
    }

    @Override
    protected void testNumber(BigDecimal number) throws LimitingDocument.Rejection {
        NumberDocument.validateNumberWithinRange(number, this.myMin, this.myMax, this.myAllowFloatingPoint);
    }

    static String createNumberString(BigDecimal value, boolean isFloatingPointNumber) {
        if (isFloatingPointNumber) {
            return String.format("%f", value);
        }
        return String.format("%d", value.toBigInteger());
    }

    static void validateNumberWithinRange(BigDecimal numberToTest, BigDecimal minValue, BigDecimal maxValue, boolean isFloatingPointNumber) throws LimitingDocument.Rejection {
        if (minValue != null && numberToTest.compareTo(minValue) < 0) {
            throw new LimitingDocument.Rejection(String.format("Number %s is less than the minimum value %s.", NumberDocument.createNumberString(numberToTest, isFloatingPointNumber), NumberDocument.createNumberString(minValue, isFloatingPointNumber)));
        }
        if (maxValue != null && numberToTest.compareTo(maxValue) > 0) {
            throw new LimitingDocument.Rejection(String.format("Number %s is greater than the maximum value %s.", NumberDocument.createNumberString(numberToTest, isFloatingPointNumber), NumberDocument.createNumberString(maxValue, isFloatingPointNumber)));
        }
    }
}

