/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.AbstractNumbersDocument;
import com.ericsson.vareditor.document.LimitingDocument;
import com.ericsson.vareditor.document.NumberDocument;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class NumbersDocument
extends AbstractNumbersDocument {
    private boolean myRequireIncreasingRange;
    private BigDecimal myMin;
    private BigDecimal myMax;
    private boolean myAllowFloatingPoint;

    public NumbersDocument(Pattern delims, boolean allowRange, boolean allowFloatingPoint) {
        super(delims, allowRange, allowFloatingPoint);
        this.myAllowFloatingPoint = allowFloatingPoint;
    }

    public NumbersDocument(Pattern delims, boolean allowRange, BigInteger min, BigInteger max) {
        this(delims, allowRange, false);
        this.myMin = new BigDecimal(min);
        this.myMax = new BigDecimal(max);
    }

    public NumbersDocument(Pattern delims, boolean allowRange, BigDecimal min, BigDecimal max) {
        this(delims, allowRange, true);
        this.myMin = min;
        this.myMax = max;
    }

    public NumbersDocument(Pattern delims, boolean allowRange, long min, long max) {
        this(delims, allowRange, BigInteger.valueOf(min), BigInteger.valueOf(max));
    }

    public NumbersDocument(Pattern delims, boolean allowRange, double min, double max) {
        this(delims, allowRange, BigDecimal.valueOf(min), BigDecimal.valueOf(max));
    }

    public void requireIncreasingRange() {
        this.myRequireIncreasingRange = true;
    }

    @Override
    protected void testNumber(BigDecimal number) throws LimitingDocument.Rejection {
        NumberDocument.validateNumberWithinRange(number, this.myMin, this.myMax, this.myAllowFloatingPoint);
    }

    @Override
    protected void testRange(BigDecimal from, BigDecimal to) throws LimitingDocument.Rejection {
        if (this.myRequireIncreasingRange && from.compareTo(to) >= 0) {
            throw new LimitingDocument.Rejection(String.format("The range %s-%s is must be increasing, which it is not.", NumberDocument.createNumberString(from, this.myAllowFloatingPoint), NumberDocument.createNumberString(to, this.myAllowFloatingPoint)));
        }
    }
}

