/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.vareditor.document.LimitingDocument;
import ericsson.ere.util.StringUtil;
import java.util.regex.Pattern;

public class RateFieldDocument
extends LimitingDocument {
    private int myNumberOfDecimals;

    public RateFieldDocument(boolean acceptNegativeValues, int numberOfDecimals) {
        super(RateFieldDocument.createPattern(acceptNegativeValues));
        this.myNumberOfDecimals = numberOfDecimals;
    }

    private static Pattern createPattern(boolean acceptNegativeValues) {
        StringBuilder strBuilder = new StringBuilder("[0-9.");
        if (acceptNegativeValues) {
            strBuilder.append("-");
        }
        strBuilder.append("]");
        return Pattern.compile(strBuilder.toString());
    }

    private void checkNumOfDecimals(RatingDecimal value) {
        value.round(this.myNumberOfDecimals, 7);
    }

    @Override
    protected void testWholeText(String text) throws LimitingDocument.Rejection {
        boolean valid = false;
        if (!StringUtil.isEmptyString(text)) {
            try {
                RatingDecimal value = new RatingDecimal(text);
                if (this.myNumberOfDecimals > -1) {
                    this.checkNumOfDecimals(value);
                }
                valid = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!valid) {
            throw new LimitingDocument.Rejection("Invalid value: " + text);
        }
    }
}

