/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.LimitingDocument;
import java.util.regex.Pattern;

public class TokenizingDocument
extends LimitingDocument {
    private Pattern myDelimiterPattern;
    private Pattern myTokenPattern;

    protected TokenizingDocument(Pattern characterPattern, Pattern delimiterPattern) {
        super(characterPattern, null);
        if (delimiterPattern == null) {
            throw new IllegalArgumentException("Null delimiter pattern not permitted.");
        }
        this.myDelimiterPattern = delimiterPattern;
    }

    protected TokenizingDocument(Pattern characterPattern, Pattern tokenPattern, Pattern delimiterPattern) {
        this(characterPattern, delimiterPattern);
        if (tokenPattern == null) {
            throw new IllegalArgumentException("Null token pattern not permitted.");
        }
        this.myTokenPattern = tokenPattern;
    }

    @Override
    protected void testByCharacter(String text) throws LimitingDocument.Rejection {
        try {
            super.testByCharacter(text);
        }
        catch (LimitingDocument.Rejection rt) {
            String[] tokens;
            for (String token : tokens = this.getTokens(text)) {
                super.testByCharacter(token);
            }
        }
    }

    @Override
    protected void testWholeText(String text) throws LimitingDocument.Rejection {
        String[] tokens;
        for (String token : tokens = this.getTokens(text)) {
            this.testToken(token);
        }
    }

    protected String[] getTokens(String text) {
        if (this.myDelimiterPattern != null) {
            return this.myDelimiterPattern.split(text);
        }
        return new String[0];
    }

    protected void testToken(String token) throws LimitingDocument.Rejection {
        if (this.myTokenPattern == null) {
            throw new IllegalStateException("testToken must be overridden by a sub class.");
        }
        if (!this.myTokenPattern.matcher(token).matches()) {
            throw new LimitingDocument.Rejection("The token " + token + " is invalid.");
        }
    }

    protected static final boolean validateDelimiterPattern(Pattern delimiterPattern, String prototypeString) {
        String[] split = delimiterPattern.split(prototypeString);
        return split.length == 1 && split[0].equals(prototypeString);
    }
}

