/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere;

import com.ericsson.ere.dataset.jump.EreJumperSuppport;
import com.ericsson.ere.io.IOCloser;
import ericsson.ere.EreLibLoaderMessengerInterface;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.exception.EreFileException;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.progress.NullProgressIndicator;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EreManagerLoader {
    public static final String TAG_MANAGER = "Manager";
    public static final String TAG_NAME = "Name";
    public static final String TAG_DEFINITIONFILE = "DefinitionFile";
    public static final String TAG_CONDITIONLEAFCLASSFILE = "ConditionLeafClassFile";
    public static final String TAG_STARTDATE = "StartDate";
    public static final String TAG_RATINGSTRUCTUREFILE = "RatingStructureFile";
    public static final String TAG_UTILITY = "Utility";
    public static final String[] ATTR_SERVICE = new String[]{"Name", "DefinitionFile", "ConditionLeafClassFile"};
    public static final String[] ATTR_SERVICE_PROVIDER = new String[]{"Name"};
    public static final String[] ATTR_RATING_PLAN = new String[]{"Name", "Service"};
    public static final String[] ATTR_RATING_PERIOD = new String[]{"Name", "StartDate", "RatingStructureFile"};
    public static String KEY_WORKINGDIRECTORY = "ERE_WorkingDirectory";
    private final EreManager myManager;
    private EreLibLoaderMessengerInterface myMessenger = null;
    private boolean myThrowException;

    public EreManagerLoader(EreManager manager) {
        this.myManager = manager;
    }

    public void setMessenger(EreLibLoaderMessengerInterface messenger) {
        this.myMessenger = messenger;
    }

    protected void printMessage(int level, String message) {
        if (this.myMessenger != null) {
            this.myMessenger.print(level, message);
        }
    }

    public void loadManagerFromXML() throws Exception {
        this.loadManagerFromXML(null, true);
    }

    public void loadManagerFromXML(boolean throwException) throws Exception {
        this.loadManagerFromXML(null, throwException);
    }

    public void loadManagerFromXML(ProgressIndicator progress, boolean throwException) throws Exception {
        this.myThrowException = throwException;
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] aprogress = new ProgressIndicator[]{null, null, null};
        aprogress = pi.splitProgress(new int[]{10, 100, 100});
        ProgressIndicator managerProgress = aprogress[0];
        ProgressIndicator serviceProgress = aprogress[1];
        ProgressIndicator providerProgress = aprogress[2];
        managerProgress.progressStart();
        managerProgress.setInfo("Loading RatingManager file...");
        NodeList aList = this.getMgrNodeList();
        Node mgrNode = aList.item(0);
        this.setEreManagerName(mgrNode);
        NodeList children = mgrNode.getChildNodes();
        managerProgress.progressFinished();
        List<Element> services = XMLUtil.getElementNodesNamed("ServiceList", children);
        for (Element service : services) {
            this.readServiceList(service, serviceProgress);
        }
        List<Element> providers = XMLUtil.getElementNodesNamed("ServiceProviderList", children);
        for (Element provider : providers) {
            this.readServiceProviderList(provider, providerProgress);
        }
    }

    private void setEreManagerName(Node mgrNode) {
        if (mgrNode.hasAttributes()) {
            String name = XMLUtil.getAttributeValue(mgrNode.getAttributes(), TAG_NAME, this.myManager.getName());
            this.myManager.setName(name);
            this.printMessage(0, "Rating Manager name: " + name);
        }
    }

    protected NodeList getMgrNodeList() throws Exception, EreFileException {
        Document mgrDoc;
        String config = System.getProperty("RatingManagerFile");
        File mgrFile = new File(EreManagerLoader.getFullFilename(config));
        if (mgrFile.exists()) {
            this.printMessage(0, "Loading Rating Manager file from " + mgrFile.getPath());
            mgrDoc = XMLUtil.documentFromFile(mgrFile);
        } else {
            InputStream in = EreClassLoader.getResourceAsStream(config);
            if (in != null) {
                this.printMessage(0, "Loading Rating Manager file " + config + " from CLASSPATH.");
                mgrDoc = XMLUtil.buildDocument(in);
            } else {
                this.printMessage(2, "Could NOT Load Rating Manager file " + mgrFile.getPath() + " from file system, or " + config + " from CLASSPATH.");
                throw new EreFileException(config, "File not found");
            }
        }
        NodeList aList = mgrDoc.getElementsByTagName(TAG_MANAGER);
        if (aList.getLength() <= 0 || !aList.item(0).getNodeName().equals(TAG_MANAGER)) {
            this.printMessage(2, "No Manager Definition found in the Rating Manager file.");
            throw new EreFileException(config, "Not a Manager Definition");
        }
        return aList;
    }

    private void readServiceList(Node serviceListNode, ProgressIndicator progress) {
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        List<Element> services = XMLUtil.getElementNodesNamed("Service", serviceListNode.getChildNodes());
        if (services.size() > 0) {
            pi.setInfo("Loading services...");
            pi.progressStart(services.size());
        }
        for (Element serviceNode : services) {
            if (!this.checkAttributes(serviceNode, ATTR_SERVICE)) continue;
            String serviceName = serviceNode.getAttribute(TAG_NAME);
            String defFileName = serviceNode.getAttribute(TAG_DEFINITIONFILE);
            String condFileName = serviceNode.getAttribute(TAG_CONDITIONLEAFCLASSFILE);
            this.printMessage(0, "Loading service: " + serviceName);
            pi.setInfo("Loading service: " + serviceName);
            try {
                Service service = new Service(serviceName);
                this.startService(service, defFileName, condFileName);
                this.myManager.addService(service.getId(), service);
            }
            catch (Exception x) {
                String errMsg = "Failed to start service " + serviceName + " " + x.getMessage();
                this.printMessage(1, errMsg + "\nMessage:\n" + x.getMessage());
            }
            pi.progressIncrement();
        }
        pi.progressFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService(Service service, String defFileName, String condFileName) throws Exception {
        block7: {
            String defFilePath = this.getFileStreamName(defFileName);
            service.setDefinitionFileName(defFilePath);
            InputStream definitionStream = this.getFileStream(defFileName);
            String condFilePath = this.getFileStreamName(condFileName);
            service.setConditionsFileName(condFilePath);
            InputStream conditionStream = this.getFileStream(condFileName);
            try {
                if (definitionStream != null && conditionStream != null) {
                    service.startService(definitionStream, conditionStream);
                    service.setJumperSupport(new EreJumperSuppport(this.myManager));
                    String msg = String.format("Service %s started from definition file %s and condition file %s.", service.getId(), service.getDefinitionFileName(), service.getConditionsFileName());
                    this.printMessage(0, msg);
                    break block7;
                }
                if (definitionStream != null) {
                    service.setConditionsFileName(null);
                    service.startService(definitionStream);
                    service.setJumperSupport(new EreJumperSuppport(this.myManager));
                    String msg = String.format("Service %s started from definition file %s.", service.getId(), service.getDefinitionFileName());
                    this.printMessage(0, msg);
                    break block7;
                }
                StringBuffer msg = new StringBuffer("File not found: ");
                if (conditionStream == null) {
                    msg.append(condFilePath);
                }
                if (definitionStream == null) {
                    msg.append(defFilePath);
                }
                msg.append(".\nService \"").append(service.getId()).append("\" not started.");
                throw new IOException(msg.toString());
            }
            finally {
                IOCloser.closeIgnoringException(definitionStream);
                IOCloser.closeIgnoringException(conditionStream);
            }
        }
    }

    protected InputStream getFileStream(String filename) throws IOException {
        if (filename != null && filename.length() > 0) {
            String filepath = EreManagerLoader.getFullFilename(filename);
            File file = new File(filepath);
            if (file.exists() && file.isFile()) {
                return new BufferedInputStream(new FileInputStream(filepath));
            }
            return EreClassLoader.getResourceAsStream(filename);
        }
        return null;
    }

    protected String getFileStreamName(String filename) {
        if (filename != null && filename.length() > 0) {
            String filepath = EreManagerLoader.getFullFilename(filename);
            File file = new File(filepath);
            if (file.exists() && file.isFile()) {
                return filepath;
            }
            return filename;
        }
        return filename;
    }

    private void readServiceProviderList(Node node, ProgressIndicator progress) throws Exception {
        List<Element> providers = XMLUtil.getElementNodesNamed("ServiceProvider", node.getChildNodes());
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] aprogress = new ProgressIndicator[providers.size()];
        if (providers.size() > 0) {
            pi.setInfo("Loading service providers...");
            aprogress = pi.splitProgress(providers.size());
        }
        int len = providers.size();
        for (int i = 0; i < len; ++i) {
            Element providerNode = providers.get(i);
            if (!this.checkAttributes(providerNode, ATTR_SERVICE_PROVIDER)) continue;
            String providerName = XMLUtil.getAttributeValue(providerNode.getAttributes(), TAG_NAME, "");
            this.printMessage(0, "Loading service provider: " + providerName);
            ServiceProvider provider = new ServiceProvider(providerName);
            this.myManager.addServiceProvider(provider.getName(), provider);
            List<Element> plans = XMLUtil.getElementNodesNamed("RatingPlan", providerNode.getChildNodes());
            pi.setInfo("Loading service provider: " + providerName);
            aprogress[i].progressStart(plans.size());
            int nplan = plans.size();
            for (int j = 0; j < nplan; ++j) {
                this.createRatingPlan(provider, plans.get(j));
                aprogress[i].progressIncrement();
            }
            aprogress[i].progressFinished();
        }
    }

    private void createRatingPlan(ServiceProvider serviceProvider, Element node) throws Exception {
        if (!this.checkAttributes(node, ATTR_RATING_PLAN)) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        String planName = attributes.getNamedItem(TAG_NAME).getNodeValue();
        String serviceName = attributes.getNamedItem("Service").getNodeValue();
        this.printMessage(0, "Loading rating plan '" + planName + "' (for service '" + serviceName + "')");
        RatingPlan ratingPlan = new RatingPlan(serviceProvider, planName + "%" + serviceProvider.getName(), planName, serviceName);
        ratingPlan.setService(serviceName, this.myManager);
        serviceProvider.addRatingPlan(ratingPlan);
        List<Element> periods = XMLUtil.getElementNodesNamed("RatingPeriod", node.getChildNodes());
        for (Element period : periods) {
            this.createPeriod(serviceProvider, serviceName, ratingPlan, period);
        }
    }

    private void createPeriod(ServiceProvider serviceProvider, String serviceName, RatingPlan ratingPlan, Element period) throws Exception {
        if (this.checkAttributes(period, ATTR_RATING_PERIOD)) {
            NamedNodeMap periodAttributes = period.getAttributes();
            String periodName = periodAttributes.getNamedItem(TAG_NAME).getNodeValue();
            String start = periodAttributes.getNamedItem(TAG_STARTDATE).getNodeValue();
            String f = periodAttributes.getNamedItem(TAG_RATINGSTRUCTUREFILE).getNodeValue();
            String fileName = EreManagerLoader.getFullFilename(f);
            RatingPeriod ratingPeriod = new RatingPeriod(periodName, ratingPlan, serviceName, serviceProvider.getName(), fileName, "A", DateUtil.parse(start), DateUtil.parse(start));
            this.startPeriod(ratingPlan, fileName, ratingPeriod);
        }
    }

    private void startPeriod(RatingPlan ratingPlan, String fileName, RatingPeriod ratingPeriod) throws Exception {
        block4: {
            String prefix = String.format("Rating period '%s' with start date %s (from file %s): ", ratingPeriod.getName(), ratingPeriod.getStartTime(), fileName);
            try {
                ratingPeriod.startStructure(this.getFileStream(fileName));
                int result = ratingPlan.addRatingPeriod(ratingPeriod);
                if (0 == result) {
                    this.printMessage(0, prefix + "STARTED");
                } else {
                    this.printMessage(1, prefix + "not added (" + this.describeOperationResult(result) + ")");
                }
            }
            catch (Exception e) {
                this.printMessage(1, prefix + "failed to start: " + e.getMessage());
                if (!this.myThrowException) break block4;
                throw e;
            }
        }
    }

    private String describeOperationResult(int result) {
        String msg;
        switch (result) {
            case 0: {
                msg = "OK";
                break;
            }
            case 1: {
                msg = "already exists";
                break;
            }
            case 2: {
                msg = "not found";
                break;
            }
            case 3: {
                msg = "not allowed";
                break;
            }
            case 4: {
                msg = "unknown error";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled OperationResult code: " + result));
            }
        }
        return msg;
    }

    public static String getFullFilename(String name) {
        File f = new File(name);
        if (f.isAbsolute()) {
            return name;
        }
        return EreManagerLoader.getWorkingDirectoryString() + EreManagerLoader.backSlashToSlash(name);
    }

    public static String getWorkingDirectoryString() {
        return EreManagerLoader.backSlashToSlash(System.getProperty(KEY_WORKINGDIRECTORY));
    }

    public static String getAbsoluteRatingManagerFile() {
        return EreManagerLoader.getFullFilename(System.getProperty("RatingManagerFile"));
    }

    public static String getRatingManagerFileName() {
        return System.getProperty("RatingManagerFile");
    }

    private boolean checkAttributes(Element node, String[] attrs) {
        boolean result = true;
        StringBuffer msg = null;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            msg = new StringBuffer();
            msg.append("Missing attributes: ");
            for (int i = 0; i < attrs.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(attrs[i]);
            }
            msg.append(". ");
            result = false;
        } else {
            int missCount = 0;
            for (String attr : attrs) {
                if (attributes.getNamedItem(attr) != null) continue;
                if (msg == null) {
                    msg = new StringBuffer();
                    msg.append("Missing attribute: ");
                }
                if (missCount++ > 0) {
                    msg.append(", ");
                }
                msg.append(attr);
            }
            boolean bl = result = missCount == 0;
        }
        if (msg != null) {
            this.printMessage(1, msg.toString() + "\nIn context: " + XMLUtil.getStringRepresentation(node));
        }
        return result;
    }

    public static String backSlashToSlash(String str) {
        return str.replace('\\', '/');
    }
}

