/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere;

import ericsson.ere.RatingDataType;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.Debug;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;

public class RatingDataField {
    private String myName;
    private String myType;
    private int myTagNumber;
    private String[] myValues;
    private boolean myHasTagNumber = false;
    private boolean mySupportArray = false;
    private boolean isCreated = false;
    private boolean isMandatory = false;
    private boolean isResult = false;
    private boolean isUsed = false;
    private List<Object> valueObject = new ArrayList<Object>();

    public RatingDataField(String name, String type, boolean supportArray) {
        this.myName = name;
        this.mySupportArray = supportArray;
        this.myType = type;
    }

    public RatingDataField(String name, int tagNumber, String type, boolean supportArray) {
        this.myName = name;
        this.myTagNumber = tagNumber;
        this.myHasTagNumber = true;
        this.mySupportArray = supportArray;
        this.myType = type;
    }

    public boolean supportArray() {
        return this.mySupportArray;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean m) {
        this.isMandatory = m;
    }

    public boolean hasTagNumber() {
        return this.myHasTagNumber;
    }

    public int getTagNumber() {
        return this.myTagNumber;
    }

    public Object getFirstValue() {
        if (this.valueObject.size() > 0) {
            return this.valueObject.get(0);
        }
        return null;
    }

    public Object getValue(int index) {
        if (this.valueObject.size() > index) {
            return this.valueObject.get(index);
        }
        return null;
    }

    public Object[] getObjectArray(Object[] objectBuffer) {
        return this.valueObject.toArray(objectBuffer);
    }

    public Object[] getObjectArray() {
        return this.valueObject.toArray();
    }

    public void addValue(Object value) {
        this.valueObject.add(value);
    }

    public void setValue(Object value) {
        this.valueObject.set(0, value);
    }

    public void setValue(int index, Object value) {
        this.valueObject.set(index, value);
    }

    public int getNumberOfValues() {
        return this.valueObject.size();
    }

    public void setValues(int type, Object[] values) {
        if (RatingDataType.string(type).equals(this.getDataType())) {
            this.valueObject = new ArrayList<Object>();
            for (int ii = 0; ii < values.length; ++ii) {
                this.valueObject.add(values[ii]);
            }
        } else if (Debug.isDebug()) {
            Debug.debug("ERROR : Type missMatch, myType = " + this.myType + " added type = " + RatingDataType.string(type));
            Debug.debug("values not added ...");
        }
    }

    public String getDataType() {
        if (this.mySupportArray) {
            return this.myType + "[]";
        }
        return this.myType;
    }

    public void setValues(String type, String[] values) {
        block43: {
            block61: {
                block60: {
                    block59: {
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        block54: {
                                            block53: {
                                                block52: {
                                                    block51: {
                                                        block50: {
                                                            block49: {
                                                                block48: {
                                                                    block47: {
                                                                        block46: {
                                                                            block45: {
                                                                                block44: {
                                                                                    block42: {
                                                                                        this.myType = type;
                                                                                        this.myValues = values;
                                                                                        this.valueObject = new ArrayList<Object>();
                                                                                        if (!this.myType.equals("String") && !this.myType.equals("#String") && !this.myType.equals("#AdressString") && !this.myType.equals("#OctetString") && !this.myType.equals("#DdrString")) break block42;
                                                                                        for (int ii = 0; ii < values.length; ++ii) {
                                                                                            this.valueObject.add(this.myValues[ii]);
                                                                                        }
                                                                                        break block43;
                                                                                    }
                                                                                    if (!this.myType.equals("#Duration") && !this.myType.equals("#UnsignedInt32") && !this.myType.equals("#UnsignedInt16") && !this.myType.equals("#UnsignedInt8")) break block44;
                                                                                    for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                                        if (this.myValues[ii] == null) {
                                                                                            this.valueObject.add(null);
                                                                                            continue;
                                                                                        }
                                                                                        this.valueObject.add(new Long(this.myValues[ii]));
                                                                                    }
                                                                                    break block43;
                                                                                }
                                                                                if (!this.myType.equals("#Time")) break block45;
                                                                                for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                                    if (this.myValues[ii] == null) {
                                                                                        this.valueObject.add(null);
                                                                                        continue;
                                                                                    }
                                                                                    this.valueObject.add(DateUtil.parse(this.myValues[ii]));
                                                                                }
                                                                                break block43;
                                                                            }
                                                                            if (!this.myType.equals("Integer") && !this.myType.equals("UInteger")) break block46;
                                                                            for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                                if (this.myValues[ii] == null) {
                                                                                    this.valueObject.add(null);
                                                                                    continue;
                                                                                }
                                                                                this.valueObject.add(new Integer(this.myValues[ii]));
                                                                            }
                                                                            break block43;
                                                                        }
                                                                        if (!this.myType.equals("#MonetaryUnits")) break block47;
                                                                        for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                            if (this.myValues[ii] == null) {
                                                                                this.valueObject.add(null);
                                                                                continue;
                                                                            }
                                                                            this.valueObject.add(EreDefs.monetaryUnitStringToDouble(this.myValues[ii]));
                                                                        }
                                                                        break block43;
                                                                    }
                                                                    if (!this.myType.equals("Boolean")) break block48;
                                                                    for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                        if (this.myValues[ii] == null) {
                                                                            this.valueObject.add(null);
                                                                            continue;
                                                                        }
                                                                        this.valueObject.add(new Boolean(this.myValues[ii]));
                                                                    }
                                                                    break block43;
                                                                }
                                                                if (!this.myType.equals("Double")) break block49;
                                                                for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                    if (this.myValues[ii] == null) {
                                                                        this.valueObject.add(null);
                                                                        continue;
                                                                    }
                                                                    this.valueObject.add(new Double(this.myValues[ii]));
                                                                }
                                                                break block43;
                                                            }
                                                            if (!this.myType.equals("Date")) break block50;
                                                            for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                                if (this.myValues[ii] == null) {
                                                                    this.valueObject.add(null);
                                                                    continue;
                                                                }
                                                                this.valueObject.add(DateUtil.parse(this.myValues[ii]));
                                                            }
                                                            break block43;
                                                        }
                                                        if (!this.myType.equals("Long") && !this.myType.equals("ULong")) break block51;
                                                        for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                            if (this.myValues[ii] == null) {
                                                                this.valueObject.add(null);
                                                                continue;
                                                            }
                                                            this.valueObject.add(new BigInteger(this.myValues[ii]).longValue());
                                                        }
                                                        break block43;
                                                    }
                                                    if (!this.myType.equals("Integer") && !this.myType.equals("UInteger")) break block52;
                                                    for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                        if (this.myValues[ii] == null) {
                                                            this.valueObject.add(null);
                                                            continue;
                                                        }
                                                        this.valueObject.add(new BigInteger(this.myValues[ii]).intValue());
                                                    }
                                                    break block43;
                                                }
                                                if (!this.myType.equals("Short") && !this.myType.equals("UShort")) break block53;
                                                for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                    if (this.myValues[ii] == null) {
                                                        this.valueObject.add(null);
                                                        continue;
                                                    }
                                                    this.valueObject.add(new BigInteger(this.myValues[ii]).shortValue());
                                                }
                                                break block43;
                                            }
                                            if (!this.myType.equals("Duration")) break block54;
                                            for (int ii = 0; ii < this.myValues.length; ++ii) {
                                                System.out.println("ERROR in RatingDataField.setValues(" + this.myValues[ii] + ") for Duration NOT implemented");
                                            }
                                            break block43;
                                        }
                                        if (!this.myType.equals("MonetaryUnits")) break block55;
                                        for (int ii = 0; ii < this.myValues.length; ++ii) {
                                            if (this.myValues[ii] == null) {
                                                this.valueObject.add(null);
                                                continue;
                                            }
                                            this.valueObject.add(new MonetaryUnits(this.myValues[ii]));
                                        }
                                        break block43;
                                    }
                                    if (!this.myType.equals("Decimal")) break block56;
                                    for (int ii = 0; ii < this.myValues.length; ++ii) {
                                        if (this.myValues[ii] == null) {
                                            this.valueObject.add(null);
                                            continue;
                                        }
                                        this.valueObject.add(new Decimal(this.myValues[ii]));
                                    }
                                    break block43;
                                }
                                if (!this.myType.equals("Time")) break block57;
                                for (int ii = 0; ii < this.myValues.length; ++ii) {
                                    if (this.myValues[ii] == null) {
                                        this.valueObject.add(null);
                                        continue;
                                    }
                                    this.valueObject.add(new Time(this.myValues[ii]));
                                }
                                break block43;
                            }
                            if (!this.myType.equals("BcdString")) break block58;
                            for (int ii = 0; ii < this.myValues.length; ++ii) {
                                try {
                                    if (this.myValues[ii] == null) {
                                        this.valueObject.add(null);
                                        continue;
                                    }
                                    this.valueObject.add(BcdString.valueOf(this.myValues[ii]));
                                    continue;
                                }
                                catch (Exception e) {
                                    System.out.println("ERROR in RatingDataField.setValues(" + this.myValues[ii] + ") for BcdString '0' added");
                                    this.valueObject.add(new BcdString(""));
                                }
                            }
                            break block43;
                        }
                        if (!this.myType.equals("OctetString")) break block59;
                        for (int ii = 0; ii < this.myValues.length; ++ii) {
                            try {
                                if (this.myValues[ii] == null) {
                                    this.valueObject.add(null);
                                    continue;
                                }
                                this.valueObject.add(OctetString.valueOf(this.myValues[ii]));
                                continue;
                            }
                            catch (Exception e) {
                                System.out.println("ERROR in RatingDataField.setValues(" + this.myValues[ii] + ") for OctetString '0' added");
                                this.valueObject.add(new OctetString(""));
                            }
                        }
                        break block43;
                    }
                    if (!this.myType.equals("UnsignedInt32")) break block60;
                    for (int ii = 0; ii < this.myValues.length; ++ii) {
                        if (this.myValues[ii] == null) {
                            this.valueObject.add(null);
                            continue;
                        }
                        this.valueObject.add(new UnsignedInt32((int)Long.parseLong(this.myValues[ii])));
                    }
                    break block43;
                }
                if (!this.myType.equals("UnsignedInt16")) break block61;
                for (int ii = 0; ii < this.myValues.length; ++ii) {
                    if (this.myValues[ii] == null) {
                        this.valueObject.add(null);
                        continue;
                    }
                    this.valueObject.add(new UnsignedInt16((short)Integer.parseInt(this.myValues[ii])));
                }
                break block43;
            }
            if (!this.myType.equals("UnsignedInt8")) break block43;
            for (int ii = 0; ii < this.myValues.length; ++ii) {
                if (this.myValues[ii] == null) {
                    this.valueObject.add(null);
                    continue;
                }
                this.valueObject.add(new UnsignedInt8((byte)Short.parseShort(this.myValues[ii])));
            }
        }
    }

    public void clear() {
        this.myValues = null;
        this.isCreated = false;
        this.isResult = false;
        this.isUsed = false;
    }

    public void setDefault(String aDefault, boolean isValueList) {
        this.isCreated = false;
        this.isResult = false;
        this.isUsed = false;
        String[] defaultStrings = new String[1];
        if (isValueList) {
            StringTokenizer token = new StringTokenizer(aDefault, ";");
            int i = 0;
            defaultStrings = new String[token.countTokens()];
            while (token.hasMoreTokens()) {
                defaultStrings[i] = token.nextToken();
                ++i;
            }
        } else {
            defaultStrings[0] = aDefault;
        }
        this.setValues(this.myType, defaultStrings);
    }

    public String getName() {
        return this.myName;
    }

    public String getType() {
        if (this.mySupportArray) {
            return this.myType + "[]";
        }
        return this.myType;
    }

    public String[] getValueArray() {
        String[] valueArray = new String[this.valueObject.size()];
        for (int ii = 0; ii < this.valueObject.size(); ++ii) {
            Object o = this.valueObject.get(ii);
            valueArray[ii] = o == null ? null : ("Date".equals(this.myType) ? DateUtil.format((Calendar)o) : o.toString());
        }
        return valueArray;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public boolean isResult() {
        return this.isResult;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void isCreated(boolean theIsCreated) {
        this.isCreated = theIsCreated;
    }

    public void isResult(boolean theIsResult) {
        this.isResult = theIsResult;
    }

    public void isUsed(boolean theIsUsed) {
        this.isUsed = theIsUsed;
    }

    public String toString() {
        return this.myName;
    }
}

